<?php
/**
 * YggDore Library Configuration
 *
 * This file is configuration file for YggDore Base Library.
 *
 * @package YggDore.Base
 * @author YggDore Co.,Ltd.
 */


/*
 * -----------------------------------------------------------------
 * System Configuration
 * -----------------------------------------------------------------
 */


/**
 * Max integer value
 */
define( "YGG_INTMAX", PHP_INT_MAX );

/**
 * Min integer value
 */
define( "YGG_INTMIN", ~PHP_INT_MAX );

/**
 * EOL Code
 */
define( "YGG_EOL", PHP_EOL );


/*
 * -----------------------------------------------------------------
 * String Configuration
 * -----------------------------------------------------------------
 */


/**
 * Default byte size of max string length
 *
 * This value is used in YggString::stable method and so on.
 * This value is used to check string size of web request.
 *
 * @see YggString::stable
 */
define( "YGG_YSSLIMIT", 32768 );


/*
 * -----------------------------------------------------------------
 * YggSendMail Configuration
 * -----------------------------------------------------------------
 */


/**
 * Path to sendmail
 *
 * This value is used in YggSendMail class.
 * This value is specified path to sendmail.
 *
 * @see YggSendMail
 */
define( "YGG_SENDMAILPATH", "/usr/sbin/sendmail" );


/*
 * -----------------------------------------------------------------
 * YggRuntimeException Configuration
 * -----------------------------------------------------------------
 */


/**
 * Status of empty (YggRuntimeException common status)
 *
 * YggRuntimeException class can set any string.
 * This is one of its status.
 *
 * @see YggRuntimeException
 */
define( "YGG_STS_EMPTY", "YGG_STS_EMPTY" );

/**
 * Status of data format (YggRuntimeException common status)
 *
 * YggRuntimeException class can set any string.
 * This is one of its status.
 *
 * @see YggRuntimeException
 */
define( "YGG_STS_FORMAT", "YGG_STS_FORMAT" );

/**
 * Status of not found (YggRuntimeException common status)
 *
 * YggRuntimeException class can set any string.
 * This is one of its status.
 *
 * @see YggRuntimeException
 */
define( "YGG_STS_NOTFOUND",	"YGG_STS_NOTFOUND" );

/**
 * Status of already registration (YggRuntimeException common status)
 *
 * YggRuntimeException class can set any string.
 * This is one of its status.
 *
 * @see YggRuntimeException
 */
define( "YGG_STS_ALREADY", "YGG_STS_ALREADY" );

/**
 * Status of over limit (YggRuntimeException common status)
 *
 * YggRuntimeException class can set any string.
 * This is one of its status.
 *
 * @see YggRuntimeException
 */
define( "YGG_STS_LIMIT", "YGG_STS_LIMIT" );

/**
 * Status of not same (YggRuntimeException common status)
 *
 * YggRuntimeException class can set any string.
 * This is one of its status.
 *
 * @see YggRuntimeException
 */
define( "YGG_STS_NOTSAME", "YGG_STS_NOTSAME" );
?>
