<?php
/**
 * Integer value operation class
 *
 * This file defines YggIntJP class.
 * It includes methods to check integer value and so on.
 *
 * @package YggDore.Base.Locale.JP
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggInt class
 */
require_once( "YggDore/Base/YggInt.php" );
/**
 * Require YggStringJP file
 */
require_once( "YggDore/Base/Locale/JP/YggStringJP.php" );


/**
 * Integer value operation class
 *
 * This class has methods to check integer value and so on.
 *
 * @package YggDore.Base.Locale.JP
 */
class YggIntJP extends YggInt {
	/**
	 * Convert type of including comma string format to integer values
	 *
	 * This method converts from digit string of $data that has comma to integer value.<br />
	 * This method supports to convert zenkaku numeric too.<br />
	 * This method throws UnexpectedValueException when error occurs.
	 *
	 * <code>
	 * $data = "５，９２０";
	 * $rts  = YggIntJP::convJP( $data );
	 * (Result)
	 * $rts => 5920</pre>
	 * </code>
	 *
	 * @param integer $data Target string
	 * @return integer Result integer value
	 */
	public static function conv( $data )
	{
		$data = YggStringJP::convASCII( $data );
		if( $data == "" ){
			throw new UnexpectedValueException;
		}

		return YggInt::conv( $data );
	}
}
?>
