<?php
/**
 * Mysqli class
 *
 * This file defines YggMySQLi class.
 * It includes methods to create sql query for mysql and so on.
 *
 * @package YggDore.Base.Locale.JP
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggStringJP file
 */
require_once( "YggDore/Base/Locale/JP/YggStringJP.php" );


/**
 * Mysqli class
 *
 * This class has methods to create sql query method for mysql and so on.
 * This class extends YggMySQLi class.
 *
 * <code>
 * $mysqli = new YggMySQLiJP("localhost", "my_user", "my_password", "world");
 * $rts1 = $mysqli->sql_string( "aaa" );
 * $rts2 = $mysqli->sql_string( "" );
 * $rts3 = $mysqli->sql_string( null );
 * $mysqli->close();
 *
 * (Result)
 * $rts1 => "'aaa'";
 * $rts2 => "''";
 * $rts3 => "null";
 * </code>
 *
 * @package YggDore.Base.Locale.JP
 */
class YggMySQLiJP extends YggMySQLi {
	/**
	 * Split keyword and create sql query
	 *
	 * $wsstr splits keywords per space character and
	 * sql query is created from $sql, $sep and $mode arguments.<br />
	 * If sql query of $sql has "%WORD%" code, it replaces to word.
	 * It is made per number of keywords. $sep is added among sql queries.<br />
	 * $mode is specified type of keyword.
	 *
	 * @param string $wsstr Target string
	 * @param string $sql Query string
	 * @param string $sep Separate word of keyword
	 * @param integer $mode Same as $sit of YggMySQLi::sql_data
	 * @return string
	 */
	public function sql_word_split( $wsstr, $sql, $sep = "AND", $mode = self::STRING )
	{
		$wsstr = YggStringJP::spaceOne( $wsstr );

		return parent::sql_word_split( $wsstr, $sql, $sep, $mode );
	}
}
?>
