<?php
/**
 * Numeric class
 *
 * This file defines YggNumericJP class.
 * It includes methods to convert to numeric.
 *
 * @package YggDore.Base.Locale.JP
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggNumeric file
 */
require_once( "YggDore/Base/YggNumeric.php" );
/**
 * Require YggStringJP file
 */
require_once( "YggDore/Base/Locale/JP/YggStringJP.php" );



/**
 * Numeric class
 *
 * This class has methods to convert to numeric.
 *
 * @package YggDore.Base.Locale.JP
 */
class YggNumericJP extends YggNumeric {
	/**
	 * Convert to numeric from string
	 *
	 * This method converts from numeric string to numeric.
	 * This method supports coverting comma numeric format.<br />
	 * If result of converting is integer value, type of integer is returned,
	 * otherwise type of float is returned.<br />
	 * This method supports to convert zenkaku numeric too.<br />
	 * This method throws UnexpectedValueException when error occurs.
	 *
	 * @param string $data Target value
	 * @return int_or_float
	 */
	public static function conv( $data )
	{
		$data = YggStringJP::convASCII( $data );
		if( $data == "" ){
			throw new UnexpectedValueException;
		}

		return YggNumeric::conv( $data );
	}
}
?>
