<?php
/**
 * Sendmail class
 *
 * This file defines YggSendMailJP class.
 * It includes methods to send mail.
 *
 * @package YggDore.Base.Locale.JP
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggSendMail class
 */
require_once( "YggDore/Base/YggSendMail.php" );
/**
 * Require YggMailFormatterJP class
 */
require_once( "YggDore/Base/Locale/JP/YggMailFormatterJP.php" );


/**
 * Sendmail class
 *
 * This class has methods to send mail.
 * When this class transports data, pipe to sendmail is used.
 * It means to be very slow when you want to send a lot of mail.
 *
 * <code>
 * (Normal)
 * $mailobj = YggSendmailJP::open( YggSendMailJP::SINGLEPART );
 * $mailobj->toList( 
 *     array(
 *         array( "ADDR" => "hoge@yggdore.com", "NAME" => "hogehoge" ),
 *         array( "ADDR" => "test@yggdore.com" )
 *     )
 * );
 * $mailobj->from( "webmaster@yggdore.com", "YggDore Webmaster" );
 * $mailobj->subject( "Title" );
 * $mailobj->message( "hogehoge.\nhoge." );
 * $mailobj->close();
 *
 * (Attaching test.txt mail)
 * $mailobj = YggSendmailJP::open( YggSendMailJP::MULTIPART );
 * $mailobj->toList( 
 *     array(
 *         array( "ADDR" => "hoge@yggdore.com", "NAME" => "hogehoge" ),
 *         array( "ADDR" => "test@yggdore.com" )
 *     )
 * );
 * $mailobj->from( "webmaster@yggdore.com", "YggDore Webmaster" );
 * $mailobj->subject( "Title" );
 * $mailobj->Boundary();
 * $mailobj->message( "hogehoge.\nhoge." );
 * $mailobj->Boundary();
 * $mailobj->attachData( "test.txt", "testdata" );
 * $mailboj->close();
 * </code>
 *
 * @package YggDore.Base.Locale.JP
 */
class YggSendMailJP extends YggSendMail {
	/**
	 * Open pipe to sendmail
	 *
	 * This method opens pipe of sendmail specified by $smpath.<br />
	 * This method opens sendmail with "-t $smopt".
	 * Be careful if you use $smopt for security.<br />
	 * If you want to use Envelope-From, you should call YggSendMailJP::openFrom method.<br />
	 * $mode is mail sending mode.
	 * YggSendMailJP::SINGLEPART use to send text only mail.
	 * YggSendMailJP::MULTIPART use to send text and attaching data mail.<br />
	 * If $mf is specified NULL, YggMailFormatterJP is used in the instance.<br />
	 * YggSendMailJP::close method must be called when you finishes to use the instance.
	 *
	 * @param integer $mode Sendmail mode<br />
	 * YggSendMailJP::SINGLEPART : Send simple text mail<br />
	 * YggSendMailJP::SINGLEPART : Send text and attaching data mail
	 * @param string $smpath Path of sendmail
	 * @param string $smopt Sendmail option
	 * @param YggMailFormatter $mf Mail format controller
	 * @return YggSendMailJP
	 */
	public static function open(
		$mode = self::SINGLEPART,
		$smpath = YGG_SENDMAILPATH,
		$smopt = "",
		$mf = null
	)
	{
		if( $mf === null ){
			$mf = new YggMailFormatterJP;
		}

		return parent::open( $mode, $smpath, $smopt, $mf );
	}


	/**
	 * Open pipe to sendmail and send Envelope-FROM
	 *
	 * This method opens pipe of sendmail specified by $smpath.<br />
	 * This method opens sendmail with "$smpath -t -f$efrom $smopt".
	 * Be careful if you use $smopt for security.<br />
	 * $mode is that sending mail mode.
	 * YggSendMailJP::SINGLEPART may use to send text only mail.
	 * YggSendMailJP::MULTIPART may use to send text and attaching data mail.<br />
	 * If $mf is specified NULL, YggMailFormatterJP is used in the instance.<br />
	 * YggSendMailJP::close method must be called when you finishes to use the instance.
	 *
	 * @param string $efrom Envelope-From address
	 * @param integer $mode Sendmail mode<br />
	 * YggSendMailJP::SINGLEPART : Send simple text mail<br />
	 * YggSendMailJP::SINGLEPART : Send text and attaching data mail
	 * @param string $smpath Path of sendmail
	 * @param string $smopt Sendmail option
	 * @param YggMailFormatter $mf Mail format controller
	 * @return YggSendMailJP
	 */
	public static function openEnvelopeFrom(
		$efrom,
		$mode = self::SINGLEPART,
		$smpath = YGG_SENDMAILPATH,
		$smopt = "",
		$mf = null
	)
	{
		if( $mf === null ){
			$mf = new YggMailFormatterJP;
		}

		return parent::openEnvelopeFrom(
			$efrom, $mode, $smpath, $smopt, $mf
		);
	}


	/**
	 * Open pipe to sendmail
	 *
	 * This method opens pipe of sendmail specified by $smpath.<br />
	 * This method opens sendmail with "$smopt".
	 * Be careful if you use $smopt for security.<br />
	 * $mode is mail sending mode.
	 * YggSendMailJP::SINGLEPART use to send text only mail.
	 * YggSendMailJP::MULTIPART use to send text and attaching data mail.<br />
	 * If $mf is specified NULL, YggMailFormatterJP is used in the instance.<br />
	 * YggSendMailJP::close method must be called when you finishes to use the instance.
	 *
	 * @param integer $mode Sendmail mode<br />
	 * YggSendMailJP::SINGLEPART : Send simple text mail<br />
	 * YggSendMailJP::SINGLEPART : Send text and attaching data mail
	 * @param string $smpath Path of sendmail
	 * @param string $smopt Sendmail option
	 * @param YggMailFormatter $mf Mail format controller
	 * @return YggSendMailJP
	 */
	public static function openCommand(
		$mode = self::SINGLEPART,
		$smpath = YGG_SENDMAILPATH,
		$smopt = "",
		$mf = null
	)
	{
		if( $mf === null ){
			$mf = new YggMailFormatterJP;
		}

		return parent::openCommand( $mode, $smpath, $smopt, $mf );
	}
}
?>
