<?php
/**
 * Web request class
 *
 * This file defines YggWebRequestIconv class.
 * It includes methods to get request data from client.
 *
 * @package YggDore.Base.Locale
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggRawWebRequest class
 */
require_once( "YggDore/Base/YggRawWebRequest.php" );
/**
 * Require YggStringIconv class
 */
require_once( "YggDore/Base/Locale/YggStringIconv.php" );


/**
 * Web request class
 *
 * This class has methods to get request data from client.
 *
 * <code>
 * $req = YggWebRequestIconv::getRequest( array( "test" ), "SJIS", "UTF-8", 1024 );
 * </code>
 *
 * @package YggDore.Base.Locale
 */
class YggWebRequestIconv {
	/**
     * Get $_REQUEST
	 *
	 * This method extracts data matched with keys of $keyl in $_REQUEST and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $senc to $denc.
     *
	 * @param array $keyl Target key list
	 * @param string $senc String encoding of $_REQUEST elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getRequestArray( $keyl, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		return YggStringIconv::stableArray(
			YggRawWebRequest::getRequest(), $keyl, $senc, $denc, $limit
		);
	}


	/**
     * Get a data of $_REQUEST
	 *
	 * This method extracts data matched with $key in $_REQUEST and converts it to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $senc to $denc.
     *
	 * @param arraykey $key Target key name
	 * @param string $senc String encoding of $_REQUEST element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getRequest( $key, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		$data = self::getRequestArray( array( $key ), $senc, $denc, $limit );
		return $data[$key];
	}


	/**
     * Get $_POST
	 *
	 * This method extracts data matched with keys of $keyl in $_POST and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $senc to $denc.
     *
	 * @param array $keyl Target key list
	 * @param string $senc String encoding of $_POST elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getPostArray( $keyl, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		return YggStringIconv::stableArray(
			YggRawWebRequest::getPost(), $keyl, $senc, $denc, $limit
		);
	}


	/**
     * Get a data of $_POST
	 *
	 * This method extracts data matched with $key in $_POST and converts it to safety.
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $senc to $denc.
     *
	 * @param arraykey $key Target key name
	 * @param string $senc String encoding of $_POST element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getPost( $key, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		$data = self::getPostArray( array( $key ), $senc, $denc, $limit );
		return $data[$key];
	}


	/**
     * Get $_GET
	 *
	 * This method extracts data matched with keys of $keyl in $_GET and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $senc to $denc.
     *
	 * @param array $keyl Target key list
	 * @param string $senc String encoding of $_GET elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getGetArray( $keyl, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		return YggStringIconv::stableArray(
			YggRawWebRequest::getGet(), $keyl, $enc, $limit
		);
	}


	/**
     * Get a data of $_GET
	 *
	 * This method extracts data matched with $key in $_GET and converts it to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $senc to $denc.
     *
	 * @param arraykey $key Target key name
	 * @param string $senc String encoding of $_GET element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getGet( $key, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		$data = self::getGetArray( array( $key ), $senc, $denc, $limit );
		return $data[$key];
	}


	/**
     * Get $_COOKIE
	 *
	 * This method extracts data matched with keys of $keyl in $_COOKIE and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $senc to $denc.
     *
	 * @param array $keyl Target key list
	 * @param string $senc String encoding of $_COOKIE elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getCookieArray( $keyl, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		return YggStringIconv::stableArray(
			YggRawWebRequest::getCookie(), $keyl, $senc, $denc, $limit
		);
	}


	/**
     * Get a data of $_COOKIE
	 *
	 * This method extracts data matched with $key in $_COOKIE and converts it to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $senc to $denc.
     *
	 * @param arraykey $key Target key name
	 * @param string $senc String encoding of $_COOKIE element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getCookie( $key, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		$data = self::getCookieArray( array( $key ), $senc, $denc, $limit );
		return $data[$key];
	}


	/**
     * Get $_ENV
	 *
	 * This method extracts data matched with keys of $keyl in $_ENV and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $senc to $denc.
     *
	 * @param array $keyl Target key list
	 * @param string $senc String encoding of $_ENV elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getEnvArray( $keyl, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		return YggStringIconv::stableArray(
			YggRawWebRequest::getEnv(), $keyl, $senc, $denc, $limit
		);
	}


	/**
     * Get a data of $_ENV
	 *
	 * This method extracts data matched with $key in $_ENV and converts it to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $senc to $denc.
     *
	 * @param arraykey $key Target key name
	 * @param string $senc String encoding of $_ENV element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getEnv( $key, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		$data = self::getEnvArray( array( $key ), $senc, $denc, $limit );
		return $data[$key];
	}


	/**
     * Get $_SERVER
	 *
	 * This method extracts data matched with keys of $keyl in $_SERVER and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $senc to $denc.
     *
	 * @param array $keyl Target key list
	 * @param string $senc String encoding of $_SERVER elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getServerArray( $keyl, $senc = "", $denc = "", $limit = YGG_YSSLIMIT )
	{
		return YggStringIconv::stableArray(
			YggRawWebRequest::getServer(), $keyl, $senc, $denc, $limit
		);
	}


	/**
     * Get a data of $_SERVER
	 *
	 * This method extracts data matched with $key in $_SERVER and converts it to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $senc to $denc.
     *
	 * @param arraykey $key Target key name
	 * @param string $senc String encoding of $_SERVER element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $denc Destination string encode<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getServer( $key, $senc ="", $denc = "", $limit = YGG_YSSLIMIT )
	{
		$data = self::getServerArray( array( $key ), $senc, $denc, $limit );
		return $data[$key];
	}


	/**
     * Get $_FILES
	 *
	 * This method extracts data matched with keys of $keyl in $_FILES and
	 * filename (name and tmp_name elements) is converted to safety.<br />
	 * If file name length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $nmse to $nmde.
     *
	 * @param array $keyl Target key list
	 * @param string $nmse String encoding of file name of $_FILES elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $nmde Destination string encode of file name<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $nmlimit Limit string length of file name
     * @return array
     */
	public static function getFilesArray( $keyl, $nmse = "", $nmde = "", $nmlimit = YGG_YSSLIMIT )
	{
		if( $nmlimit < 0 ){
			throw new UnexpectedValueException;
		}

		$data = YggSafe::safeArray( YggRawWebRequest::getFiles() );
		$data = YggArray::extract( $data, $keyl );

		foreach( $keyl as $key ){
			if( $data[$key] === null ){
				continue;
			}
			elseif( $data[$key]['tmp_name'] == "" ||
			        $data[$key]['name'] == "" ){
				$data[$key] = null;
				continue;
			}

			$data[$key]['name'] = YggStringIconv::stable(
				$data[$key]['name'], $nmse, $nmde, $nmlimit
			);
		}

		return $data;
	}


	/**
     * Get a data of $_FILES
	 *
	 * This method extracts data matched with $key in $_FILES and
	 * filename (name and tmp_name elements) is converted to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $nmse to $nmde.
     *
	 * @param arraykey $key Target key name
	 * @param string $nmse String encoding of file name of $_FILES element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param string $nmde Destination string encode of file name<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $nmlimit Limit string length of file name
     * @return array
     */
	public static function getFiles( $key, $nmse = "", $nmde = "", $nmlimit = YGG_YSSLIMIT )
	{
		$data = self::getFilesArray( array( $key ), $nmse, $nmde, $nmlimit );
		return $data[$key];
	}
}
?>
