<?php
/**
 * Web request class
 *
 * This file defines YggWebRequestUTF8 class.
 * It includes methods to get request data from client.
 *
 * @package YggDore.Base.Locale
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggWebRequestIconv class
 */
require_once( "YggDore/Base/Locale/YggWebRequestIconv.php" );


/**
 * Web request class
 *
 * This class has methods to get request data from client.
 *
 * <code>
 * $req = YggWebRequestUTF8::getRequest( array( "test" ), "SJIS", 1024 );
 * </code>
 *
 * @package YggDore.Base.Locale
 */
class YggWebRequestUTF8 {
	/**
     * Get $_REQUEST
	 *
	 * This method extracts data matched with keys of $keyl in $_REQUEST and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $enc to UTF-8.
     *
	 * @param array $keyl Target key list
	 * @param string $enc String encoding of $_REQUEST elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getRequestArray( $keyl, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getRequestArray( $keyl, $enc, "UTF-8", $limit );
	}


	/**
     * Get a data of $_REQUEST
	 *
	 * This method extracts data matched with $key in $_REQUEST and converts it to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $enc to UTF-8.
     *
	 * @param arraykey $key Target key name
	 * @param string $enc String encoding of $_REQUEST element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getRequest( $key, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getRequest( $key, $enc, "UTF-8", $limit );
	}


	/**
     * Get $_POST
	 *
	 * This method extracts data matched with keys of $keyl in $_POST and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $enc to UTF-8.
     *
	 * @param array $keyl Target key list
	 * @param string $enc String encoding of $_POST elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getPostArray( $keyl, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getPostArray( $keyl, $enc, "UTF-8", $limit );
	}


	/**
     * Get a data of $_POST
	 *
	 * This method extracts data matched with $key in $_POST and converts it to safety.
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $enc to UTF-8.
     *
	 * @param arraykey $key Target key name
	 * @param string $enc String encoding of $_POST element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getPost( $key, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getPost( $key, $enc, "UTF-8", $limit );
	}


	/**
     * Get $_GET
	 *
	 * This method extracts data matched with keys of $keyl in $_GET and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $enc to UTF-8.
     *
	 * @param array $keyl Target key list
	 * @param string $enc String encoding of $_GET elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getGetArray( $keyl, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getGetArray( $keyl, $enc, "UTF-8", $limit );
	}


	/**
     * Get a data of $_GET
	 *
	 * This method extracts data matched with $key in $_GET and converts it to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $enc to UTF-8.
     *
	 * @param arraykey $key Target key name
	 * @param string $enc String encoding of $_GET element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getGet( $key, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getGet( $key, $enc, "UTF-8", $limit );
	}


	/**
     * Get $_COOKIE
	 *
	 * This method extracts data matched with keys of $keyl in $_COOKIE and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $enc to UTF-8.
     *
	 * @param array $keyl Target key list
	 * @param string $enc String encoding of $_COOKIE elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getCookieArray( $keyl, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getCookieArray( $keyl, $enc, "UTF-8", $limit );
	}


	/**
     * Get a data of $_COOKIE
	 *
	 * This method extracts data matched with $key in $_COOKIE and converts it to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $enc to UTF-8.
     *
	 * @param arraykey $key Target key name
	 * @param string $enc String encoding of $_COOKIE element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getCookie( $key, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getCookie( $key, $enc, "UTF-8", $limit );
	}


	/**
     * Get $_ENV
	 *
	 * This method extracts data matched with keys of $keyl in $_ENV and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $enc to UTF-8.
     *
	 * @param array $keyl Target key list
	 * @param string $enc String encoding of $_ENV elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getEnvArray( $keyl, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getEnvArray( $keyl, $enc, "UTF-8", $limit );
	}


	/**
     * Get a data of $_ENV
	 *
	 * This method extracts data matched with $key in $_ENV and converts it to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $enc to UTF-8.
     *
	 * @param arraykey $key Target key name
	 * @param string $enc String encoding of $_ENV element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getEnv( $key, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getEnv( $key, $enc, "UTF-8", $limit );
	}


	/**
     * Get $_SERVER
	 *
	 * This method extracts data matched with keys of $keyl in $_SERVER and
	 * converts them to safety.<br />
	 * If string length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $enc to UTF-8.
     *
	 * @param array $keyl Target key list
	 * @param string $enc String encoding of $_SERVER elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return array
     */
	public static function getServerArray( $keyl, $enc = "", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getServerArray( $keyl, $enc, "UTF-8", $limit );
	}


	/**
     * Get a data of $_SERVER
	 *
	 * This method extracts data matched with $key in $_SERVER and converts it to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $enc to UTF-8.
     *
	 * @param arraykey $key Target key name
	 * @param string $enc String encoding of $_SERVER element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $limit Limit string length
     * @return string
     */
	public static function getServer( $key, $enc ="", $limit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getServer( $keyl, $enc, "UTF-8", $limit );
	}


	/**
     * Get $_FILES
	 *
	 * This method extracts data matched with keys of $keyl in $_FILES and
	 * filename (name and tmp_name elements) is converted to safety.<br />
	 * If file name length of each elements of the data more than $limit, it fixes to $limit.
	 * If NULL code is found in it, returns string before it.
	 * This function defends NULL byte attach.<br />
	 * These data are converted from $nmenc to UTF-8.
     *
	 * @param array $keyl Target key list
	 * @param string $nmenc String encoding of file name of $_FILES elements specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $nmlimit Limit string length of file name
     * @return array
     */
	public static function getFilesArray( $keyl, $nmenc = "", $nmlimit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getFilesArray( $keyl, $nmenc, "UTF-8", $nmlimit );
	}


	/**
     * Get a data of $_FILES
	 *
	 * This method extracts data matched with $key in $_FILES and
	 * filename (name and tmp_name elements) is converted to safety.<br />
	 * If string length of the data is more than $limit, it fixes to $limit.
	 * If NULL code is found in it, string It is cut before NULL.
	 * This function defends NULL byte attach.<br />
	 * The data is converted from $nmenc to UTF-8.
     *
	 * @param arraykey $key Target key name
	 * @param string $nmenc String encoding of file name of $_FILES element specified by $keyl<br />
	 * Internal encoding is used if it is empty.
	 * @param integer $nmlimit Limit string length of file name
     * @return array
     */
	public static function getFiles( $key, $nmenc = "", $nmlimit = YGG_YSSLIMIT )
	{
		return YggWebRequestIconv::getFiles( $key, $nmenc, "UTF-8", $nmlimit );
	}
}
?>
