<?php
/**
 * Array class
 *
 * This file defines YggArray class.
 * It includes methods to operate array methods.
 *
 * @package YggDore.Base
 * @author YggDore Co.,Ltd.
 */



/**
 * Array class
 *
 * This class has methods to operate array.
 * Its all methods are static methods.
 *
 * @package YggDore.Base
 */
class YggArray {
	/**
	 * Extract data in array
	 *
	 * The method extracts data from array and return it.<br />
	 * $data is specified target array data.<br />
	 * $keyl is specified extraction key list.<br />
	 * If $data doesn't have some $keyl elements,
	 * NULL is used and set to the element of return array.<br />
	 * This method throws UnexpectedValueException when error occurs.
	 *
	 * <code>
	 * $data = array( "test2" => "", "test3" => "hoge" );
	 * $keyl = array( "test1", "test2" );
	 * YggArray::extract( $data, $keyl );
	 * (Result)
	 * $data => (
	 *     "test1" => null,
	 *     "test2" => ""
	 * );
	 * </code>
	 *
	 * @param array $data Target array data
	 * @param array $keyl Extraction key list
	 * @return array Result array
	 */
	public static function extract( $data, $keyl )
	{
		if( count($keyl) <= 0 ){
			throw new UnexpectedValueException;
		}

		$rts = array();
		foreach( $keyl as $key ){
			if( isset($data[$key]) ){
				$rts[$key] = $data[$key];
				continue;
			}

			$rts[$key] = null;
		}

		return $rts;
	}


	/**
	 * Optimize array
	 *
	 * The method checks whether keys of $keyl exist in $data.<br />
	 * If $data doesn't have some $keyl elements,
	 * NULL is set to the element of $data.<br />
	 * This method throws UnexpectedValueException when error occurs.
	 *
	 * <code>
	 * $data = array( "test2" => "" );
	 * $keyl = array( "test1", "test2" );
	 * YggArray::optimize( $data, $keyl );
	 * (Result)
	 * $data => (
	 *     "test1" => null,
	 *     "test2" => ""
	 * );
	 * </code>
	 *
	 * @param array &$data Target array
	 * @param array $keyl Checking key list
	 */
	public static function optimize( &$data, $keyl )
	{
		if( count($keyl) <= 0 ){
			throw new UnexpectedValueException;
		}

		foreach( $keyl as $key ){
			if( isset($data[$key]) ){
				continue;
			}

			$data[$key] = null;
		}
	}
}
?>
