<?php
/**
 * Directory operation class
 *
 * This file defines YggDirectory class.
 * It includes methods to operate directory.
 *
 * @package YggDore.Base
 * @author YggDore Co.,Ltd.
 */


/**
 * Directory operation class
 *
 * This class has methods to operate directory.
 * It has a method to adjust directory path only.
 *
 * @package YggDore.Base
 */
class YggDirectory {
	/**
	 * Adjust directory path
	 *
	 * If the last code of $path isn't slash,
	 * this method adds slash to the path and return it.
	 *
	 * @param string $path Directory path
	 * @return string Result path
	 */
	public static function endSlash( $path )
	{
		if( $path == "" ){
			throw new UnexpectedValueException;
		}

		if( substr( $path, -1 ) != "/" ){
			$path .= "/";
		}

		return $path;
	}
}
?>
