<?php
/**
 * Exception class
 *
 * This file defines YggExceptionTool class.
 * It includes methods to convert from exception object to string message.
 *
 * @package YggDore.Base
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggArray class
 */
require_once( "YggDore/Base/YggArray.php" );
/**
 * Require YggTool class
 */
require_once( "YggDore/Base/YggTool.php" );
/**
 * Require YggRuntimeException class
 */
require_once( "YggDore/Base/YggRuntimeException.php" );



/**
 * Exception class
 *
 * This class has methods to convert from exception object to string message.
 *
 * <code>
 * $err = YggExceptionTool::caseClass(
 *     new Exception,
 *     array(
 *         "case" => array(
 *             "Exception"        => "test",
 *             "RuntimeException" => "busy",
 *             ""                 => ""
 *         ),
 *         "default" => "other"
 *     )
 * );
 * (Result)
 * $err => "test"
 * </code>
 *
 * @package YggDore.Base
 */
class YggExceptionTool {
	/**
	 * Convert exception class name
	 *
	 * Class name of $e matches key of $ctbl and value of the key is returned.
	 *
	 * @param Exception_or_null $e Exception
	 * @param array $ctbl Convert table ( Same as $ctbl of YggTool::convCase method )
	 * @return string Results of converting
	 * @see YggTool::convCase()
	 */
	public static function caseClass( $e, $ctbl )
	{
		if( $e !== null ){
			$e = get_class( $e );
			if( $e == "" ){
				throw new UnexpectedValueException;
			}
		}

		return YggTool::convCase( $e, $ctbl );
	}


	/**
	 * Convert exception status
	 *
	 * Each status of $e converts by YggTool::convCaseArray with $catbl.<br />
	 * If $e is YggRuntimeException class, $e is converted,
	 * otherwise NULL value is returned.
	 * This method can call when status of YggRuntimeException is array.
	 *
	 * @param Exception_or_null $e Exception object
	 * @param array $catbl Convert table ( Same as $catbl as YggTool::convCaseArray method )
	 * @return string Results of converting
	 * @see YggTool::convCaseArray()
	 */
	public static function caseStatus( $e, $catbl )
	{
		if( $e instanceof YggRuntimeException ){
			$e = $e->getStatus();
		}
		else{
			$e = null;
		}

		return YggTool::convCaseArray( $e, $catbl );
	}
}
?>
