<?php
/**
 * Message class
 *
 * This file defines YggMessage class.
 * It includes methods to convert from exception to readable string and so on.
 *
 * @package YggDore.Base
 * @author YggDore Co.,Ltd.
 */



/**
 * Message class
 *
 * This class has method to convert from exception to readable string and so on.
 *
 * <code>
 * $ref = null;
 * $err = YggMessage::create(
 *     array(
 *         array( array( &$handlerobj, "callbackMethod1" ), 1, 2 ),
 *         array( array( &$handlerobj, "callbackMethod2" ), "test" ),
 *         array( "callbackMethod3", &$ref )
 *     )
 * );
 * </code>
 *
 * @package YggDore.Base
 */
class YggMessage {
	/**
	 * Call multi methods and merge exception
	 *
	 * This method calls callbacks specified by $cbary and
	 * returns merged return values of them.<br />
	 * <br />
	 * $cbary format is the following array.<br />
	 * <code>
	 * $cbary = array(
	 *     array( callback $cb, mixed $arg1, mixed $arg2, ..., mixed $argn ),
	 *     array( callback $cb, mixed $arg1, mixed $arg2, ..., mixed $argn ),
	 *     ...
	 * );
	 * </code><br />
	 * $cbary has some array that has callback and arguments data.<br />
	 * This method calls these callbacks and transrates argument data.<br />
	 * <br />
	 * <br />
	 * Callbacks prototype of $cbray is as follows.<br />
	 * <code>
	 * array $cbary[0..n](
	 *     mixed $arg1, mixed $arg2, ... mixed $argn, array $msg
	 * );
	 * </code><br />
	 * The arguments of $arg1,...$argn are same as array data of $cbary.<br />
	 * $msg is message array made before calling this callback.<br />
	 * Return value is message occured in the callback, no message should return NULL.
	 *
	 * @param array $cbary Callbacks array<br />
	 * (It has array in array that has the following elements)<br />
	 * [0] : Callback function or method<br />
	 * [1..n] : Data of arguments
	 * @return array_or_null Returns NULL when all of callbacks return NULL,
	 * otherwise returns return value that is merged return value of callbacks.
	 */
	public static function create( $cbary )
	{
		if( count( $cbary ) <= 0 ){
			throw new UnexpectedValueException;
		}
		for( $i = 0; $i < count( $cbary ); $i++ ){
			if( !is_callable( $cbary[$i][0] ) ){
				throw new UnexpectedValueException;
			}
		}

		$msg = null;

		for( $i = 0; $i < count( $cbary ); $i++ ){
			$cb = array_shift( $cbary[$i] );

			$cbary[$i][] = $msg; 

			$msgw = call_user_func_array( $cb, $cbary[$i] );
			if( $msgw === null ){
				continue;
			}

			if( $msg === null ){
				$msg = array();
			}
			$msg = array_merge( $msg, $msgw );
		}

		return $msg;
	}


	/**
	 * Mask message
	 *
	 * This method extracts some message specified by $mkary from $msg.
	 *
	 * @param array_or_null $msg Message
	 * @param array $mkary Extract keys list
	 * @return array_or_null Returns NULL if result is no message, otherwise returns masked message.
	 */
	public static function mask( $msg, $mkary )
	{
		if( count( $mkary ) <= 0 ){
			throw new UnexpectedValueException;
		}
		elseif( $msg === null ){
			return null;
		}

		$rts = array();
		foreach( $mkary as $key ){
			if( !isset($msg[$key]) ){
				continue;
			}

			$rts[$key] = $msg[$key];
		}
		if( count( $rts ) <= 0 ){
			return null;
		}

		return $rts;
	}


	/**
	 * Change message key
	 *
	 * This method changes each key name of $msg elements from key to value of
	 * each $ckary elements.<br />
	 * Returns NULL if $msg is NULL, otherwise returns result converted message.
	 *
	 * @param array_or_null $msg Message
	 * @param array $ckary Change message list.
	 * Its keys are key name of $msg elements, values are destination name.
	 * @return array_or_null Message
	 */
	public static function chgKey( $msg, $ckary )
	{
		if( count( $ckary ) <= 0 ){
			throw new UnexpectedValueException;
		}

		if( $msg === null ){
			return null;
		}

		$rts = array();
		foreach( $msg as $key => $value ){
			if( !isset($ckary[$key]) ){
				$rts[$key] = $msg[$key];
				continue;
			}

			$rts[$ckary[$key]] = $msg[$key];
		}
		if( count( $rts ) <= 0 ){
			return null;
		}

		return $rts;
	}


	/**
	 * Pass thru message 
	 *
	 * This method passes thru $msg.
	 * It is used to set initialization value to YggMessage::create method.
	 *
	 * @param array $rmsg Return message
	 * @param array $msg Message (Dumy)
	 * @return array_or_null Message
	 */
	public static function pass( $rmsg, $msg )
	{
		return $rmsg;
	}
}
?>
