<?php
/**
 * Numeric class
 *
 * This file defines YggNumeric class.
 * It includes methods to convert to numeric.
 *
 * @package YggDore.Base
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggInt file
 */
require_once( "YggDore/Base/YggInt.php" );
/**
 * Require YggString file
 */
require_once( "YggDore/Base/YggString.php" );


/**
 * Numeric class
 *
 * This class has methods to convert to numeric.
 *
 * @package YggDore.Base
 */
class YggNumeric {
	/**
	 * Convert to numeric from string
	 *
	 * This method converts from numeric string to numeric.
	 * This method supports coverting comma numeric format.<br />
	 * If result of converting is integer value, type of integer is returned,
	 * otherwise type of float is returned.<br />
	 * This method throws UnexpectedValueException when error occurs.
	 *
	 * @param string $data Target value
	 * @return numeric
	 */
	public static function conv( $data )
	{
		$dlen = strlen( $data );
		if( $dlen <= 0 ){
			throw new UnexpectedValueException;
		}

		$nstr = "";

		$mode = 0;					// Processing mode
									// (0:integer 1:float 2:index)
		$isc  = false;				// Flag comma existing
		$ccnt = 0;
		$icnt = array( 0, 0, 0 );
		for( $i = 0; $i < $dlen; $i++ ){
			$sc = substr( $data, $i, 1 );

			if( strspn( $sc, "0123456789" ) == 1 ){
				$ccnt++;
				$icnt[$mode]++;
				$nstr .= $sc;

				continue;
			}
			elseif( $isc && $ccnt != 3 ){
				throw new UnexpectedValueException;
			}

			if( $sc == "," ){
				if( $mode == 1 ){
					throw new UnexpectedValueException;
				}
				elseif( !$isc ){
					if( $ccnt < 1 || $ccnt > 3 ){
						throw new UnexpectedValueException;
					}

					$w = substr( $nstr, strlen($nstr) - $ccnt );
					if( (int)$w == 0 ){
						throw new UnexpectedValueException;
					}
				}

				$isc  = true;
				$ccnt = 0;

				continue;
			}
			elseif( $sc == "." ){
				if( $mode >= 1 ){
					throw new UnexpectedValueException;
				}

				$mode  = 1;
				$nstr .= $sc;
				$isc   = false;
				$ccnt  = 0;

				continue;
			}
			elseif( $sc == "e" || $sc == "E" ){
				if( $mode == 2 ){
					throw new UnexpectedValueException;
				}
				elseif( $icnt[0] == 0 && $icnt[1] == 0 ){
					throw new UnexpectedValueException;
				}

				$mode = 2;
				$nstr .= $sc;
				$isc  = false;
				$ccnt = 0;

				continue;
			}
			elseif( $sc == "+" || $sc == "-" ){
				if( $mode == 1 ){
					throw new UnexpectedValueException;
				}
				elseif( $i + 1 >= strlen( $data ) ){
					throw new UnexpectedValueException;
				}
				elseif( $icnt[$mode] != 0 ){
					throw new UnexpectedValueException;
				}
				
				$nstr .= $sc;

				continue;
			}

			throw new UnexpectedValueException;
		}
		if( $icnt[0] == 0 && $icnt[1] == 0 ){
			throw new UnexpectedValueException;
		}
		elseif( $isc && $ccnt != 3 ){
			throw new UnexpectedValueException;
		}
		elseif( !is_numeric( $nstr ) ){
			throw new UnexpectedValueException;
		}

		$val = (float)$nstr;
		if( YggInt::is( $val ) ){
			return (int)$val;
		}

		return $val;
	}
}
?>
