<?php
/**
 * Web request class
 *
 * This file defines YggRawWebRequest class.
 * It includes methods to get web request data.
 *
 * @package YggDore.Base
 * @author YggDore Co.,Ltd.
 */


/**
 * YggDore web request class
 *
 * This class has to get web request data.
 * These data doesn't be safety because data is raw.
 *
 * <code>
 * $req =& YggRawWebRequest::getRequest();
 * </code>
 *
 * @package YggDore.Base
 */
class YggRawWebRequest {
	/**
     * Get reference of $_REQUEST
     *
     * @return array Reference of $_REQUEST
     */
	public static function &getRequest()
	{
		return $_REQUEST;
	}


	/**
     * Get reference of $_POST
     *
     * @return array Reference of $_POST
     */
	public static function &getPost()
	{
		return $_POST;
	}


	/**
     * Get reference of $_GET
     *
     * @return array Reference of $_GET
     */
	public static function &getGet()
	{
		return $_GET;
	}


	/**
     * Get reference of $_FILE
     *
     * @return array Reference of $_FILES
     */
	public static function &getFiles()
	{
		return $_FILES;
	}


	/**
     * Get reference of $_COOKIE
     *
     * @return array Reference of $_COOKIE
     */
	public static function &getCookie()
	{
		return $_COOKIE;
	}


	/**
     * Get reference of $_ENV
     *
     * @return array Reference of $_ENV
     */
	public static function &getEnv()
	{
		return $_ENV;
	}


	/**
     * Get reference of $_SERVER environment
     *
     * @return array Reference of $_SERVER
     */
	public static function &getServer()
	{
		return $_SERVER;
	}
}
?>
