<?php
/**
 * Runtime exception class
 *
 * This file defines YggRuntimeException class.
 * It includes class extended RuntimeException class.
 * This class is added to store error message.
 *
 * @package YggDore.Base
 * @author YggDore Co.,Ltd.
 */


/**
 * Require config file
 */
require_once( "YggDore/Base/Config.php" );


/**
 * Runtime exception class
 *
 * This class is extended RuntimeException class.
 * It is added to store error message.
 *
 * @package YggDore.Base
 */
class YggRuntimeException extends RuntimeException {
	/**
	 * Status
	 */
	protected $status;


	/**
	 * Constructor
	 *
	 * The instance is initialized.
	 * $status can be set value anything.
	 * $message and $code are same as arguments of Exception class.
	 *
	 * @param mixed $status Status
	 * @param string $message Exception message
	 * @param integer $code Exception code
	 */
	public function __construct(
		$status = null, $message = null, $code = 0
	)
	{
		$this->status = $status;
		parent::__construct( $message, $code );
	}


	/**
	 * Get status
	 *
	 * This method returns status in the instance.
	 *
	 * @return mixed Status
	 */
	public function getStatus()
	{
		return $this->status;
	}


	/**
	 * Convert to string
	 *
	 * This method returns result of the instance information.
	 *
	 * @return string Information
	 */
	public function __toString()
	{
		return parent::__toString() .
		       "Status:" . YGG_EOL .
			   var_export( $this->status, true );
	}
}
?>
