<?php
/**
 * Server status class
 *
 * This file defines YggServerStatus class.
 * It includes methods to get information of server status.
 *
 * @package YggDore.Base
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggWebRequest class
 */
require_once( "YggDore/Base/YggWebRequest.php" );
/**
 * Require YggSafe class
 */
require_once( "YggDore/Base/YggSafe.php" );


/**
 * Server status class
 *
 * This class has methods to get information of server status.
 *
 * <code>
 * $mode = YggServerStatus::getConnProto();
 * </code>
 *
 * @package YggDore.Base
 */
class YggServerStatus {
	/**
	 * HTTP Connection mode
	 */
	const HTTP = 1;
	/**
	 * HTTPS Connection mode
	 */
	const HTTPS = 2;


	/**
	 * Get connection protocol type
	 *
	 * This method returns connetion way from client.
	 *
	 * @return integer Returns YggServerStatus::HTTPS when connection is used ssl,
	 * otherwise returns YggServerStatus::HTTP.
	 */
	public static function getConnProto()
	{
		$iss = YggWebRequest::getServer( "HTTPS", 32 );
		if( $iss != "" ){
			return self::HTTPS;
		}

		return self::HTTP;
	}


	/**
	 * Get server name
	 *
	 * This method returns this server name.
	 *
	 * @return string Server name
	 */
	public static function getServerName()
	{
		return YggWebRequest::getServer( "SERVER_NAME", 255 );
	}


	/**
	 * Parse environment value of HTTP_ACCEPT_LANGUAGE
	 *
	 * This method parses environment value of HTTP_ACCEPT_LANGUAGE and
	 * returns result that is sorted order to priority ascending.<br />
	 * This method throws RuntimeException when error occurs.
	 *
	 * @return array
	 */
	public static function getAcceptLang()
	{
		$lang = YggWebRequest::getServer( "HTTP_ACCEPT_LANGUAGE", 1024 );
		if( $lang == "" ){
			return array();
		}

		$wtbl = array();
		$rs   = split( ",", $lang, 1024 );
		foreach( $rs as $rec ){
			$r = array(
				"L" => "",
				"Q" => 1.0
			);

			$w = split( ";", $rec, 2 );
			
			$r['L'] = strtolower( trim( $w[0] ) );
			if( $r['L'] == "" ){
				break;
			}
				
			if( count($w) < 2 ){
				$wtbl[] = $r;
				continue;
			}

			if( !preg_match( '/q=([0-9.]+)/', $w[1], $m ) ){
				throw new RuntimeException;
			}

			$r['Q'] = YggSafe::safeNumeric( $m[1] );
			if( $r['Q'] < 0 || $r['Q'] > 1 ){
				throw new RuntimeException;
			}

			$wtbl[] = $r;
		}

		for( $i = 0; $i < count($wtbl); $i++ ){
			for( $j = 0; $j < count($wtbl) - $i - 1; $j++ ){
				if( $wtbl[$j]['Q'] < $wtbl[$j+1]['Q'] ){
					$w          = $wtbl[$j];
					$wtbl[$j]   = $wtbl[$j+1];
					$wtbl[$j+1] = $w;
				}
			}
		}

		$rts = array();
		for( $i = 0; $i < count($wtbl); $i++ ){
			$rts[] = $wtbl[$i]['L'];
		}

		return $rts;
	}
}
?>
