<?php
/**
 * Theme methods
 *
 * This file defines YSThemeEN class.
 * It includes methods to convert string encode to internal and so on.
 *
 * @package YggDore.Server.Base.Theme.EN
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggStringIconv class
 */
require_once( "YggDore/Base/Locale/YggStringIconv.php" );
/**
 * Require YggWebRequestUTF8 class
 */
require_once( "YggDore/Base/Locale/YggWebRequestUTF8.php" );
/**
 * Require YggMobileJP class
 */
require_once( "YggDore/Base/Locale/JP/YggMobileJP.php" );
/**
 * Require YSSession class
 */
require_once( "YggDore/Server/Base/YSSession.php" );



/**
 * Theme methods
 *
 * This class has methods to convert string encode to internal and so on.
 *
 * @package YggDore.Server.Base.Theme.EN
 */
class YSThemeEN {
	/**
     * Get request
	 *
	 * This method extracts data matched with keys of $keyl in $_REQUEST and
	 * converts them to safety.
     *
	 * @param array $keyl Target key list
     * @return array
     */
	public static function getRequestArray( $keyl )
	{
		return YggWebRequestUTF8::getRequestArray( $keyl, "UTF-8" );
	}


	/**
     * Get request data
	 *
	 * This method extracts data matched with $key in $_REQUEST and converts it to safety.
     *
	 * @param arraykey $key Target key name
     * @return string
     */
	public static function getRequest( $key )
	{
		return YggWebRequestUTF8::getRequest( $key, "UTF-8" );
	}


	/**
     * Stable string
	 *
	 * This function converts $data to stable string.
     *
	 * @param string $data Target data
	 * @param mixed $param Dumy argument for YggLogio class.
     * @return string
     */
	public static function stable( $data, $param = null )
	{
		return YggStringIconv::stable( $data, "UTF-8", "UTF-8" );
	}


	/**
	 * Get mobile mode
	 *
	 * This method returns mobile mode in this theme.
	 *
     * @return boolean
	 */
	public static function isMobile()
	{
		return false;
	}


	/**
	 * Get time zone
	 *
	 * This method returns time zone in this theme.
	 *
	 * @return integer
	 */
	public static function getTZKey()
	{
		// America/New_York
		return 153;
	}


	/**
	 * Check client type
	 *
	 * This method checks client type.
	 *
	 * @param integer $type Client type<br />
	 * It is as same as return value of YggSession::getClientType method.
	 * @return boolean If this theme supports client type specified by $type,
	 * returns TRUE, otherwise returns FALSE.
	 */
	public static function checkClientType( $type )
	{
		if( $type != YggMobileJP::CT_OTHER ){
			return false;
		}

		return true;
	}
}
?>
