<?php
/**
 * Theme methods
 *
 * This file defines YSThemeJPM class.
 * It includes methods to convert string encode to internal and so on.
 *
 * @package YggDore.Server.Base.Theme.JPM
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggStringIconv class
 */
require_once( "YggDore/Base/Locale/YggStringIconv.php" );
/**
 * Require YggWebRequestUTF8 class
 */
require_once( "YggDore/Base/Locale/YggWebRequestUTF8.php" );
/**
 * Require YggStringJP class
 */
require_once( "YggDore/Base/Locale/JP/YggStringJP.php" );
/**
 * Require YggMobileJP class
 */
require_once( "YggDore/Base/Locale/JP/YggMobileJP.php" );



/**
 * Theme methods
 *
 * This class has methods to convert string encode to internal and so on.
 *
 * @package YggDore.Server.Base.Theme.JPM
 */
class YSThemeJPM {
	/**
     * Get request
	 *
	 * This method extracts data matched with keys of $keyl in $_REQUEST and
	 * converts them to safety.
     *
	 * @param array $keyl Target key list
     * @return array
     */
	public static function getRequestArray( $keyl )
	{
		return YggWebRequestUTF8::getRequestArray( $keyl, "Shift-JIS" );
	}


	/**
     * Get request data
	 *
	 * This method extracts data matched with $key in $_REQUEST and converts it to safety.
     *
	 * @param arraykey $key Target key name
     * @return string
     */
	public static function getRequest( $key )
	{
		return YggWebRequestUTF8::getRequest( $key, "Shift-JIS" );
	}


	/**
     * Stable string
	 *
	 * This function converts $data to stable string.
     *
	 * @param string $data Target data
	 * @param mixed $param Dumy argument for YggLogio class.
     * @return string
     */
	public static function stable( $data, $param = null )
	{
		return YggStringJP::stable( $data, "Shift-JIS" );
	}


	/**
	 * Convert to SJIS
	 *
	 * This method converts stdio buffer data encoding to SJIS and output.
	 * You must call ob_start function before this method calling.
	 */
	public static function convOut()
	{
		$out = ob_get_contents();
		ob_end_clean();
		echo YggStringIconv::conv( $out, "UTF-8", "Shift-JIS" );
	}


	/**
	 * Get mobile mode
	 *
	 * This method returns mobile mode in this theme.
	 *
     * @return boolean
	 */
	public static function isMobile()
	{
		return true;
	}


	/**
	 * Get time zone
	 *
	 * This method returns time zone in this theme.
	 *
	 * @return integer
	 */
	public static function getTZKey()
	{
		// Asia/Tokyo
		return 282;
	}


	/**
	 * Check client type
	 *
	 * This method checks client type.
	 *
	 * @param integer $type Client type<br />
	 * It is as same as return value of YggSession::getClientType method.
	 * @return boolean If this theme supports client type specified by $type,
	 * returns TRUE, otherwise returns FALSE.
	 */
	public static function checkClientType( $type )
	{
		if( $type == YggMobileJP::CT_OTHER ){
			return false;
		}

		return true;
	}
}
?>
