<?php
/**
 * Config data management class
 *
 * This file defines YSConfig class.
 * It includes methods to manage configuration.
 *
 * @package YggDore.Server.Base
 * @author YggDore Co.,Ltd.
 */



/**
 * Require the server configuration file
 */
require_once( "YggDore/Server/Config/Config.php" );



/**
 * Config data management class
 *
 * This class has methods to manage configuration.
 *
 * @package YggDore.Server.Base
 */
class YSConfig {
	/**
	 * Get host name
	 *
	 * This method returns this server host name.<br />
	 * If YS_HOST is empty, $_SERVER['SERVER_NAME'] value is returned.
	 *
	 * @return string Host name
	 */
	public static function getHost()
	{
		$snm = YggWebRequest::getServer( "SERVER_NAME" );

		if( YS_HOST != "" ){
			return YS_HOST;
		}
		elseif( $snm != "" ){
			return $snm;
		}

		throw new RuntimeException;
	}


	/**
	 * Get world name
	 *
	 * This method returns this service world name.<br />
	 * If YS_WORLD is empty, YS_HOST is returned.<br />
	 * But if YS_HOST is empty, $_SERVER['SERVER_NAME'] value is returned.
	 *
	 * @return string World name
	 */
	public static function getWorld()
	{
		if( YS_WORLD != "" ){
			return YS_WORLD;
		}

		return self::getHost();
	}
}
?>
