<?php
/**
 * MySQL connection class
 *
 * This file defines YSMySQLi class.
 * It includes methods to access and operate mysql database.
 *
 * @package YggDore.Server.Base
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggMySQLi class
 */
require_once( "YggDore/Base/YggMySQLi.php" );
/**
 * Require the server configuration file
 */
require_once( "YggDore/Server/Config/Config.php" );


/**
 * MySQL connection class
 *
 * This class has methods to access and operate mysql database of YggDore Server.
 *
 * <code>
 * $mysqli = YSMySQLi::connect();
 * $mysqli->close();
 * </code>
 *
 * @package YggDore.Server.Base
 */
class YSMySQLi {
	/**
	 * Connect to YS mysql database
	 *
	 * Connect to YS mysql database and return connection object.
	 *
	 * @return YggMySQLi
	 */
	public static function connect()
	{
		$host = YS_DBHOST;
		if( YS_DBPORT != "" ){
			$host .= ":" . YS_DBPORT;
		}
		$mysqli = new YggMySQLi(
			$host, YS_DBUSER, YS_DBPASS, YS_DBNAME
		);
		if( $mysqli->connect_errno ){
			throw new RuntimeException;
		}

		if( !$mysqli->set_charset("UTF8") ){
			$mysqli->close();
			throw new RuntimeException;
		}

		return $mysqli;
	}


	/**
	 * Execute SQL query and get first record in first recordset
	 *
	 * $sql query is sent to $mysqli and returned first record in first recordset.
	 *
	 * @param string $sql SQL query
	 * @param YggMySQLi $mysqli Database connection
	 * @return Record information
	 */
	public static function queryFF( $sql, $mysqli )
	{
		$rts = $mysqli->real_query( $sql );
		if( !$rts ){
			throw new RuntimeException;
		}

		if( $mysqli->field_count <= 0 ){
			$mysqli->multi_free();
			throw new UnexpectedValueException;
		}

		$result = $mysqli->store_result();
		if( !$result ){
			$mysqli->multi_free();
			throw new RuntimeException;
		}
		elseif( $result->num_rows <= 0 ){
			$result->free();
			$mysqli->multi_free();
			throw new UnexpectedValueException;
		}
		$row = $result->fetch_assoc();
		$result->free();

		$mysqli->multi_free();

		return $row;
	}


	/**
	 * Clean table
	 *
	 * This method executes query specified by $sql and deletes old data.
	 *
	 * @param string $sql SQL query
	 * @param integer $kprs Number of seconds to delete record after it expires
	 * @param YggMySQLi $mysqli Database connection
	 */
	public static function clean( $sql, $kprs, $mysqli )
	{
		if( $sql == "" ){
			throw new UnexpectedValueException;
		}
		elseif( $kprs < 0 ){
			throw new RangeException;
		}

		$sql = $mysqli->sql(
			$sql,
			array(
				"kprs" => $kprs
			),
			array(
				"kprs" => YggMySQLi::INT
			)
		);
		$rts = $mysqli->query( $sql );
		if( !$rts ){
			throw new RuntimeException;
		}
	}
}
?>
