<?php
/**
 * Class to select language and page layout from client information
 *
 * This file defines YSTheme class.
 * It includes methods to select language and page
 * layout from client information.
 *
 * @package YggDore.Server.Base
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggServerStatus class
 */
require_once( "YggDore/Base/YggServerStatus.php" );
/**
 * Require YggWebRequest class
 */
require_once( "YggDore/Base/YggWebRequest.php" );
/**
 * Require YggMobileJP class
 */
require_once( "YggDore/Base/Locale/JP/YggMobileJP.php" );
/**
 * Require the server configuration file
 */
require_once( "YggDore/Server/Config/Config.php" );



/**
 * Class to select language and page layout from client information
 *
 * This class has methods to select language and page layout from
 * client information.
 *
 * <code>
 * $theme = YSTheme::get();
 * </code>
 *
 * @package YggDore.Server.Base
 */
class YSTheme {
	/**
	 * Get language and page theme from client information
	 *
	 * @return string One of the following theme<br />
	 * en : English<br />
	 * jp : Japanese<br />
	 * jpm : Japanese(Mobile)
	 */
	public static function get()
	{
		$cip = YggWebRequest::getServer( YS_RAKEY );
		if( YggMobileJP::matchIP( $cip ) ){
			return "jpm";
		}

		$pl = YggServerStatus::getAcceptLang();
		foreach( $pl as $lang ){
			if( $lang == "ja" ){
				return "jp";
			}
		}

		return "en";
	}
}
?>
