<?php
/**
 * Web template page class
 *
 * This file defines YSWBaseEN class.
 * It includes methods to send web template page data.
 *
 * @package YggDore.Server.BaseWeb.Theme.EN
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YSWPrefix class
 */
require_once( "YggDore/Server/BaseWeb/YSWPrefix.php" );


/**
 * Web template page class
 *
 * This class has methods to send web template page data.
 *
 * <code>
 * $bw = new YSWBaseEN;
 * $bw->sendHeader();
 * $bw->sendBody();
 * $bw->sendFooter();
 * </code>
 *
 * @package YggDore.Server.BaseWeb.Theme.EN
 */
class YSWBaseEN {
	/**
	 * Top page address
	 */
	private $_prefix;


	/**
	 * Constructor
	 *
	 * The instance is initialized.
	 */
	public function __construct()
	{
		$this->_prefix = new YSWPrefix;
	}


	/**
	 * Send header
	 *
	 * $title is value of title tag.
	 * $keywords and $desk are used to data of meta tag.
	 *
	 * @param string $title Title
	 * @param string $keywords Keyword
	 * @param string $desc Description
	 */
	public function sendHeader( $title = "", $keywords = "", $desc = "" )
	{
		if( $this->_prefix === null ){
			throw new BadMethodCallException;
		}

		if( $title == "" ){
			$title = "YggDore Sky Gate Login Test";
		}
		else{
			$title = "YggDore Sky Gate Login Test - " . $title;
		}

		// Create meta tag
		$ht = "";
		if( $keywords != "" ){
			$ht = YGG_EOT .
			      '<meta name="keywords" content="' .
			      YggHTML::specialChars( $keywords ) .
				  '" />';
		}
		if( $desc != "" ){
			$ht = YGG_EOT .
			      '<meta name="description" content="' .
			      YggHTML::specialChars( $desc ) .
				  '" />';
		}

		$cpfx = YggHTML::specialChars( $this->_prefix->getCurrent() );
		
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><?php echo YggHTML::specialChars($title); ?></title>
<?php echo $ht; ?>
<link href="<?php echo $cpfx; ?>/share/base.css" rel="stylesheet" type="text/css" />
<link href="<?php echo $cpfx; ?>/share/page.php" rel="stylesheet" type="text/css" />
<?php

	}


	/**
	 * Send body
	 */
	public function sendBody()
	{
		// Check member variable
		if( $this->_prefix === null ){
			throw new BadMethodCallException;
		}

		// Create top address of current connection mode
		$cpfx  = YggHTML::specialChars( $this->_prefix->getCurrent() );

?></head>

<body>
<div class="contents">
	<div class="head">
		<div class="headh"></div>
		<div class="logo"><img src="<?php echo $cpfx; ?>/share/logo.gif" alt="YggDore Sky Gate Login Test" width="850" height="90" /></div>
	</div>
	<div class="main">
		<div class="mainct"><?php

	}


	/**
	 * Send footer
	 */
	public function sendFooter()
	{

?></div>
	</div>
	<div class="foot">
		<div class="footlink">| <a href="http://www.yggdore.com/">Go to developer site</a> | <a href="http://www.yggdore.com/en/developer/download/">Download this program(BSD License)</a> |</div>
		<div class="footcr">Copyright 2009 YggDore Co.,Ltd. all rights reserved.</div>
	</div>
</div>
</body>
</html><?php

	}


	/**
	 * Get object to create path to top directory
	 *
	 * @return YSWPrefix
	 */
	public function getPrefix()
	{
		if( $this->_prefix === null ){
			throw new BadMethodCallException;
		}

		return $this->_prefix;
	}
}
?>
