<?php
/**
 * Web template page class
 *
 * This file defines YSWErrorJP class.
 * It includes methods to send web template page data.
 *
 * @package YggDore.Server.BaseWeb.Theme.JP
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggDore config file
 */
require_once( "YggDore/Base/Config.php" );
/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YggTool class
 */
require_once( "YggDore/Base/YggTool.php" );
/**
 * Require YggExceptionTool class
 */
require_once( "YggDore/Base/YggExceptionTool.php" );
/**
 * Require YggRuntimeException class
 */
require_once( "YggDore/Base/YggRuntimeException.php" );
/**
 * Require YggDore server config file
 */
require_once( "YggDore/Server/Config/Config.php" );
/**
 * Require YSWBaseJP class
 */
require_once( "YggDore/Server/BaseWeb/Theme/JP/YSWBaseJP.php" );


/**
 * Error web page creation class
 *
 * This class has methods to send error web page data.
 *
 * <code>
 * YSWErrorJP::send();
 * </code>
 *
 * @package YggDore.Server.BaseWeb.Theme.JP
 */
class YSWErrorJP {
	/**
	 * Send error web page
	 *
	 * Send error web page XHTML to client.
	 * Error message is created by $e.
	 * If $e is specified NULL, $e is as same as Exception.
	 *
	 * @param Exception $e Exception
	 */
	public static function send( $e = null )
	{
		if( $e === null ){
			$e = new Exception;
		}

		self::sendMsg(
			self::convException( $e )
		);
	}


	/**
	 * Send error web page 
	 *
	 * $msg is sent to client.
	 *
	 * @param string $msg Message
	 */
	public static function sendMsg( $msg )
	{
		if( $msg == "" ){
			throw new UnexpectedValueException;
		}

		$bw = new YSWBaseJP;

		$prefix = $bw->getPrefix();
		$cpfx   = YggHTML::specialChars( $prefix->getCurrent() );
		$hpfx   = YggHTML::specialChars( $prefix->getHTTP() );

		$bw->sendHeader( "エラー" );
		$bw->sendBody();

?><div class="error"><?php echo YggHTML::specialChars( $msg ); ?></div><?php

		$bw->sendFooter();
	}


	/**
	 * Convert exception to message
	 *
	 * $e is converted to message.
	 *
	 * @param Exception $e Exception
	 */
	public static function convException( $e = null )
	{
		if( $e === null ){
			$e = new Exception;
		}

		return YggExceptionTool::caseClass( $e, self::getECI() );
	}


	/**
	 * Get table to convert exception to message
	 *
	 * @return array
	 */
	public static function getECI()
	{
		return array(
			"case" => array(
				"RuntimeException" =>
					"実行中にエラーが発生し、" .
					"処理を中断しました。" .
					"大変混雑している可能性がございますので、" .
					"誠に申し訳ございませんが、" .
					"時間をお待ちいただき、" .
					"再度アクセスしていただきますよう" .
					"お願いいたします。",
				"YggRuntimeException" =>
					"エラーが発生しました。" .
					"エラー箇所には原因が表示されていますので、" .
					"修正してください。"
			),
			"default" =>
				"不正な処理が発生しました。" .
				"誠に申し訳ございませんが、" .
				"時間をお待ちいただき、" .
				"再度アクセスしていただきますようお願いいたします。"
		);
	}
}
?>
