<?php
/**
 * Web template page class
 *
 * This file defines YSWBaseJPM class.
 * It includes methods to send web template page data.
 *
 * @package YggDore.Server.BaseWeb.Theme.JPM
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YSWPrefix class
 */
require_once( "YggDore/Server/BaseWeb/YSWPrefix.php" );


/**
 * Web template page class
 *
 * This class has methods to send web template page data.
 *
 * <code>
 * $bw = new YSWBaseJPM;
 * $bw->sendHeader();
 * $bw->sendBody();
 * $bw->sendFooter();
 * </code>
 *
 * @package YggDore.Server.BaseWeb.Theme.JPM
 */
class YSWBaseJPM {
	/**
	 * Top page address
	 */
	private $_prefix;


	/**
	 * Constructor
	 *
	 * The instance is initialized.
	 */
	public function __construct()
	{
		$this->_prefix = new YSWPrefix;
	}


	/**
	 * Send header
	 *
	 * $title is value of title tag.
	 * $keywords and $desk are used to data of meta tag.
	 *
	 * @param string $title Title
	 * @param string $keywords Keyword
	 * @param string $desc Description
	 */
	public function sendHeader( $title = "", $keywords = "", $desc = "" )
	{
		if( $this->_prefix === null ){
			throw new BadMethodCallException;
		}

		if( $title == "" ){
			$title = "YggDore Sky Gate Login Test";
		}
		else{
			$title = "YggDore Sky Gate Login Test - " . $title;
		}

		// Create meta tag
		$ht = "";
		if( $keywords != "" ){
			$ht = YGG_EOT .
			      '<meta name="keywords" content="' .
			      YggHTML::specialChars( $keywords ) .
				  '" />';
		}
		if( $desc != "" ){
			$ht = YGG_EOT .
			      '<meta name="description" content="' .
			      YggHTML::specialChars( $desc ) .
				  '" />';
		}

		$cpfx = YggHTML::specialChars( $this->_prefix->getCurrent() );
		
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja" xml:lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS" />
<title><?php echo YggHTML::specialChars($title); ?></title>
<?php echo $ht; ?>
<?php

	}


	/**
	 * Send body
	 */
	public function sendBody()
	{
		// Check member variable
		if( $this->_prefix === null ){
			throw new BadMethodCallException;
		}

		// Create top address of current connection mode
		$cpfx  = YggHTML::specialChars( $this->_prefix->getCurrent() );

?></head>

<body><?php

	}


	/**
	 * Send footer
	 */
	public function sendFooter()
	{

?><center style="background-color: #eeeeee"><br />
| <a href="http://www.yggdore.com/jpm/">開発者のページへ</a> |<br />
<br /></center>
<br />
<center>
(C) YggDore CO.,LTD.<br />
2009</center>
</body>
</html><?php

	}


	/**
	 * Get object to create path to top directory
	 *
	 * @return YSWPrefix
	 */
	public function getPrefix()
	{
		if( $this->_prefix === null ){
			throw new BadMethodCallException;
		}

		return $this->_prefix;
	}
}
?>
