<?php
/**
 * Class to create path to top directory in this service
 *
 * This file defines YSWPrefix class.
 * It includes methods to create path to top directory in this service.
 *
 * @package YggDore.Server.BaseWeb
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggServerStatus class
 */
require_once( "YggDore/Base/YggServerStatus.php" );
/**
 * Require YggDore server config file
 */
require_once( "YggDore/Server/Config/Config.php" );


/**
 * Class to create path of top directory in this service
 *
 * This class has methods to create path to top directory in this service.
 *
 * <code>
 * $pcobj = new YSWPrefix();
 * $pcobj->getHTTP();
 * $pcobj->getHTTPS();
 * $pcobj->getCurrent();
 *
 * (Result) Return the following value in Config.php
 * Mode of HTTP
 * getHTTP => YS_HTTPPATH
 * getHTTPS => YS_HTTPSURL
 * getCurrent => YS_HTTPPATH
 * Mode of HTTPS
 * getHTTP => YS_HTTPURL
 * getHTTPS => YS_HTTPSPATH
 * getCurrent => YS_HTTPSPATH
 * </code>
 *
 * @package YggDore.Server.BaseWeb
 */
class YSWPrefix {
	/**
	 * Address of HTTP mode
	 */
	private $_httppfx;
	/**
	 * Address of HTTPS mode
	 */
	private $_httpspfx;
	/**
	 * Address of current mode
	 */
	private $_curpfx;
	/**
	 * Current connection mode
	 */
	private $_cptype;


	/**
	 * Constructor
	 *
	 * The instance is initialized.
	 */
	public function __construct()
	{
		$this->_httppfx  = null;
		$this->_httpspfx = null;
		$this->_curpfx   = null;
		$this->_cptype   = null;

		// Get mode by connection method from a client
		$cptype = YggServerStatus::getConnProto();
		if( $cptype != YggServerStatus::HTTPS ){
			// HTTP
			$this->_httppfx  = YS_HTTPPATH;
			$this->_httpspfx = YS_HTTPSURL;
			$this->_curpfx   = YS_HTTPPATH;
			$this->_cptype   = $cptype;
			return;
		}

		// HTTPS
		$this->_httppfx  = YS_HTTPURL;
		$this->_httpspfx = YS_HTTPSPATH;
		$this->_curpfx   = YS_HTTPSPATH;
		$this->_cptype   = $cptype;
	}


	/**
	 * Get path to top directory when HTTP connection
	 *
	 * @return string
	 */
	public function getHTTP()
	{
		return $this->_httppfx;
	}


	/**
	 * Get path to top directory when HTTPS connection
	 *
	 * @return string
	 */
	public function getHTTPS()
	{
		return $this->_httpspfx;
	}


	/**
	 * Get path to top directory of current connection method
	 *
	 * @return string
	 */
	public function getCurrent()
	{
		return $this->_curpfx;
	}


	/**
	 * Get current connection mode
	 *
	 * @return integer Connection method<br />
	 * Return YggServerStatus::HTTP if connection mode is HTTP,
	 * otherwize returns YggServerStatus::HTTPS.
	 */
	public function getConnProto()
	{
		return $this->_cptype;
	}
}
?>
