<?php
/**
 * Configuration file
 *
 * This is configuration file for this application.
 * You must copy or rename to Config.php.
 *
 * @package YggDore.Server.Config
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggDore Base Library configuration file
 * The line must not be deleted.
 */
require_once( "YggDore/Base/Config.php" );



// -----------------------------------------------------------------
// System Configuration
// -----------------------------------------------------------------


// (Configuration of mysql)

/**
 * MySQL host name
 *
 * This is specified host name or address to mysql
 */
define( "YS_DBHOST", "127.0.0.1" );

/**
 * MySQL port no
 *
 * This is specified connection port number to mysql
 */
define( "YS_DBPORT", "" );

/**
 * MySQL database name
 *
 * This is specified connection database name to mysql
 */
define( "YS_DBNAME", "YS" );

/**
 * MySQL user name
 *
 * This is specified connection user name to mysql
 */
define( "YS_DBUSER", "ys" );

/**
 * MySQL password
 *
 * This is specified connection user password to mysql
 */
define( "YS_DBPASS", "ys" );


// (Configuration of system)

/**
 * Host name
 *
 * This is specified host name for this machine.
 * If it is empty, $_SERVER['SERVER_NAME'] is used.
 * It must be registered to DNS and
 * resolving IP from DNS must be as same as local machine IP.
 */
define( "YS_HOST", "" );

/**
 * World name
 *
 * This is specified world name in which this service joins.
 * If this server is stand alone, you should set it YS_HOST.
 * If you has some machines or service and want to share ID on them,
 * you should specified your domain name.
 */
define( "YS_WORLD", YS_HOST );

/**
 * Key name of environment for getting client IP address
 *
 * This is specified key name in array of $_SERVER for getting IP address.
 * Normally, you don't need to change it.
 * If your server are connecting from a proxy server,
 * you may change it to "HTTP_X_FORWARDED_FOR" and so on.
 */
define( "YS_RAKEY", "REMOTE_ADDR" );



// -----------------------------------------------------------------
// Address configuration
// -----------------------------------------------------------------


/**
 * Path of top directory
 *
 * This is specified path of this service top directory.
 * Images and pages links are created by it.
 * Creating URL format is http://FQDN"YS_HTTPPATH"/
 * The last character must not be slash.
 */
define( "YS_HTTPPATH", "" );

/**
 * URL of top directory
 *
 * This is specified URL of this service top directory.
 * Images and pages links are created by it.
 * The last character must not be slash.
 */
define( "YS_HTTPURL", "http://www.ylogintest.com" . YS_HTTPPATH );

/**
 * Path of top directory (SSL)
 *
 * This is specified path of this service top directory.
 * Images and pages links are created by it.
 * This is used when client connection type is SSL.
 * Creating URL format is https://FQDN"YS_HTTPSPATH"/
 * The last character must not be slash.
 */
define( "YS_HTTPSPATH", "/ylogintest.com" );

/**
 * URL of top directory (SSL)
 *
 * This is specified URL of this service top directory.
 * Images and pages links are created by it.
 * This is used when client connection type is SSL.
 * Creating URL format is http://YS_HTTPSPATH/
 * The last character must not be slash.
 */
define(
	"YS_HTTPSURL", "https://ssl.yggdore.com" . YS_HTTPSPATH
);



// -----------------------------------------------------------------
// Session configuration
// -----------------------------------------------------------------


/**
 * Session name
 * 
 * This is used to cookie and request session name.
 */
define( "YS_SESSION_NAME", "yss" );



// -----------------------------------------------------------------
// Other
// -----------------------------------------------------------------


/**
 * Number of seconds until cleaning table records
 *
 * The number of seconds until each table records deletion after
 * they expire.
 */
define( "YS_LOG_KPSEC", 604800 );



// -----------------------------------------------------------------
// Data format configuration
// -----------------------------------------------------------------


/**
 * Min number of key
 */
define( "YS_KEY_MIN", 1 );

/**
 * Max character length type of string
 */
define( "YS_STRING_STRMAX", 255 );

/**
 * Max character length type of long string
 */
define( "YS_TEXT_STRMAX", 32768 );
?>
