<?php
/**
 * Class to operate echo text
 *
 * This file defines YSUEcho class.
 * It includes methods to operate echo text in database.
 *
 * @package YggDore.Server.User
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YSMySQLi class
 */
require_once( "YggDore/Server/Base/YSMySQLi.php" );



/**
 * SQL query to register echo text
 */
define(
	"YSUE_QUERY_REGETXT",
	"CALL echoText( %ukey%, %etxt% )"
);


/**
 * Class to operate echo text
 *
 * This class has methods to operate echo text in database.
 *
 * <code>
 * $mysqli = new YSMySQLi();
 * YSUEcho::updateText( $ukey, "hogehoge", $mysqli );
 * </code>
 *
 * @package YggDore.Server.User
 */
class YSUEcho {
	/**
	 * Update echo text data
	 *
	 * A user's echo text data specified by $ukey and $etxt stored to database.
	 * 
	 * @param string $ukey User key
	 * @param string $etxt Echo text
	 * @param YggMySQLi $mysqli Database connection
	 */
	public static function updateText( $ukey, $etxt, $mysqli )
	{
		$sql = $mysqli->sql(
			YSUE_QUERY_REGETXT,
			array(
				"ukey" => $ukey,
				"etxt" => $etxt
			),
			array(
				"ukey" => YggMySQLi::STRING,
				"etxt" => YggMySQLi::STRING
			)
		);
		$rts = $mysqli->query( $sql );
		if( !$rts ){
			throw new RuntimeException;
		}
	}
}
?>
