<?php
/**
 * Class to manage echo data
 *
 * This file defines YSUEchoInfo class.
 * It includes methods to manage echo data.
 *
 * @package YggDore.Server.User
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggRuntimeException class
 */
require_once( "YggDore/Base/YggRuntimeException.php" );
/**
 * Require YggMySQLi class
 */
require_once( "YggDore/Base/YggMySQLi.php" );



// SQL query of user information is loaded
define(
	"YSUEI_QUERY_LOAD",
	"SELECT ETXT FROM ECHO WHERE UKEY = %ukey%"
);



/**
 * Class to manage echo data
 *
 * This class has methods to manage echo data.
 *
 * <code>
 * $mysqli = YSMySQLi::connect(); 
 * $user = new YSUEchoInfo;
 * $user->set( $id, $mysqli );
 * </code>
 *
 * @package YggDore.Server.User
 */
class YSUEchoInfo {
	/**
	 * User key
	 */
	private $_ukey;
	/**
	 * Echo text
	 */
	private $_etxt;


	/**
	 * Constructor
	 *
	 * The instance is initialized.
	 */
	public function __construct()
	{
		$this->clear();
	}


	/**
	 * Clear
	 *
	 * Member variables of the instance is initialized.
	 */
	public function clear()
	{
		$this->_ukey = null;
		$this->_etxt = null;
	}


	/**
	 * Check instance data
	 *
	 * This method checks whether member variables are valid.<br />
	 * This method returns TRUE when they are valid, otherwise returns FALSE.
	 *
	 * @return boolean
	 */
	public function isSetIns()
	{
		if( $this->_ukey === null ){
			return false;
		}

		return true;
	}


	/**
	 * Get user key
	 *
	 * This method returns value of the instance.<br />
	 * This method throws BadMethodCallException.
	 *
	 * @return string
	 */
	public function getUKey()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		return $this->_ukey;
	}


	/**
	 * Get echo text
	 *
	 * This method returns value of the instance.<br />
	 * This method throws BadMethodCallException.
	 *
	 * @return string_or_null
	 */
	public function getText()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		return $this->_etxt;
	}


	/**
	 * Get all instance data
	 *
	 * This method returns value of the instance.<br />
	 * This method throws BadMethodCallException.
	 *
	 * @return array Instance data<br />
	 * (It has the following elements)<br />
	 * ukey : (string) User key
	 * etxt : (string_or_null) Echo text
	 */
	public function get()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		return array(
			"ukey" => $this->_ukey,
			"etxt" => $this->_etxt
		);
	}


	/**
	 * Set data to the instance
	 *
	 * This method load saving echo data from database and
	 * set to the instance.
	 *
	 * @param string $ukey User key
	 * @param YggMySQLi $mysqli Database connection
	 */
	public function set( $ukey, $mysqli )
	{
		$sql = $mysqli->sql(
			YSUEI_QUERY_LOAD,
			array(
				"ukey" => $ukey
			),
			array(
				"ukey" => YggMySQLi::STRING
			)
		);
		$row = YSMySQLi::queryFF( $sql, $mysqli );

		$this->_ukey = $ukey;
		$this->_etxt = $row['ETXT'];
	}
}
?>
