<?php
/**
 * Login page layout class
 *
 * This file defines YSLoginWebEN class.
 * It includes methods to send login page layout.
 *
 * @package YggDore.Server.UserWeb.Theme.EN
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggWebRequest class
 */
require_once( "YggDore/Base/YggWebRequest.php" );
/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YggTool class
 */
require_once( "YggDore/Base/YggTool.php" );
/**
 * Require YSWPrefix class
 */
require_once( "YggDore/Server/BaseWeb/YSWPrefix.php" );
/**
 * Require YSWBaseEN class
 */
require_once( "YggDore/Server/BaseWeb/Theme/EN/YSWBaseEN.php" );


/**
 * Login page layout class
 *
 * This class has methods to send login page layout.
 *
 * <code>
 * YSLoginWebEN::send();
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.EN
 * @author YggDore Co.,Ltd.
 */
class YSUWLoginEN {
	/**
	 * Send login web page
	 *
	 * Login web page data is sent to client.
	 */
	public static function send()
	{
		$bw  = new YSWBaseEN;
		$pfx = $bw->getPrefix();
		$svs = $pfx->getConnProto();

		$cpfx  = YggHTML::specialChars( $pfx->getCurrent() );

		$bw->sendHeader();

?>
<meta name="ysg" content="<?php echo YggHTML::specialChars( YS_HTTPSURL . "/en/mypage/?" . urlencode( "@_si" ) . "=" . urlencode( "@YSI@" ) . "&_isl=1" ); ?>" />
<link href="<?php echo $cpfx; ?>/share/top.css" rel="stylesheet" type="text/css" />
<?php

		$bw->sendBody();

?>
<div class="topmsg"> This is tool to test login using YggDore Sky Gate Server.<br />
<br />
When you login in this site, please use <a href="http://www.yggdore.com/en/app/tbff/">YggDore Sky Gate Toolbar</a> and input your login ID and password created by YggDore Sky Gate Server. <a href="http://www.yggdore.com/en/app/tbff/">&gt;&gt;Detail</a>.<br />
<br />
If you don’t have a account or you don’t know where YggDore Sky Gate Server, please see <a href="http://www.yggdore.com/">here</a> and create your account.</div> 
<?php

		$bw->sendFooter();
	}
}
?>
