<?php
/**
 * My page template class
 *
 * This file defines YSUWMPBaseEN class.
 * It includes methods to send my page layout data.
 *
 * @package YggDore.Server.UserWeb.Theme.EN
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YSWBaseEN class
 */
require_once( "YggDore/Server/BaseWeb/Theme/EN/YSWBaseEN.php" );
/**
 * Require YSUWLoginInfoEN class
 */
require_once( "YggDore/Server/UserWeb/Theme/EN/YSUWLoginInfoEN.php" );



/**
 * My page template class
 *
 * This class has methods to send my page layout data.
 *
 * <code>
 * $login = new YSUWLoginInfoEN;
 * $login->set();
 * $bw = new YSUMPBaseWeb;
 * $bw->sendHeader();
 * $bw->sendBody( $login );
 * $bw->sendFooter();
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.EN
 */
class YSUWMPBaseEN extends YSWBaseEN {
	/**
	 * Send header
	 *
	 * @param string $title Title
	 * @param string $keywords Keyword
	 * @param string $desc Description
	 */
	public function sendHeader( $title = "", $keywords = "", $desc = "" )
	{
		$pfx  = $this->getPrefix();
		$cpfx = YggHTML::specialChars( $pfx->getCurrent() );

		parent::sendHeader( $title, $keywords, $desc );
		
?>
<link href="<?php echo $cpfx; ?>/share/mypage/mypage.css" rel="stylesheet" type="text/css" />
<?php

	}


	/**
	 * Send body
	 *
	 * @param YSUWLoginInfoEN $login Login information
	 */
	public function sendBody( $login )
	{
		parent::sendBody();

?>
<div class="mpcon">
	<div class="lid">Your ID in the server : <?php echo YggHTML::specialChars( $login->getID() ); ?></div>
<?php

	}


	/**
	 * Send footer
	 */
	public function sendFooter()
	{

		echo '</div>';
		parent::sendFooter();
	}
}
?>
