<?php
/**
 * Class to manage page layout of login ID and password change
 *
 * This file defines YSUWMPTopEN class.
 * It includes methods to manage page layout of top of my page.
 *
 * @package YggDore.Server.UserWeb.Theme.EN
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YSUWLoginInfoEN class
 */
require_once( "YggDore/Server/UserWeb/Theme/EN/YSUWLoginInfoEN.php" );
/**
 * Require YSUWMPBaseEN class
 */
require_once( "YggDore/Server/UserWeb/Theme/EN/YSUWMPBaseEN.php" );



/**
 * Class to manage page layout of login ID and password change
 *
 * This class has methods to manage page layout of top of my page.
 *
 * <code>
 * $login = new YSUWLoginInfoEN;
 * $login->set();
 * YSUWMPTopEN::send( $login );
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.EN
 */
class YSUWMPTopEN {
	/**
	 * Title
	 */
	const TITLE = "My page";


	/**
	 * Send input page
	 *
	 * @param YSUWLoginInfoEN $login Login information
	 */
	public static function send( $login )
	{
		$bw = new YSUWMPBaseEN;

		$pfx  = $bw->getPrefix();
		$cpfx = YggHTML::specialChars( $pfx->getCurrent() );

		$sidq = $login->getKeepURLQuot();

		$bw->sendHeader( self::TITLE );
?>
<link href="<?php echo $cpfx; ?>/share/mypage/mypagetop.css" rel="stylesheet" type="text/css" />
<?php

		$bw->sendBody( $login );

?>
<div class="mptle"><a href="<?php echo $cpfx; ?>/en/mypage/echo/<?php echo $sidq; ?>"><img src="<?php echo $cpfx; ?>/share/mypage/echo.gif" alt="Echo" width="71" height="35" border="0" /></a></div>
<div class="mpitr">This is simple form test. Input data outputs to the page only.</div>
<div class="mptlee"><a href="<?php echo $cpfx; ?>/en/mypage/logout/<?php echo $sidq; ?>"><img src="<?php echo $cpfx; ?>/share/mypage/logout.gif" alt="Logout" width="100" height="35" border="0" /></a></div>
<?php

		$bw->sendFooter();
	}
}
?>
