<?php
/**
 * Login page layout class
 *
 * This file defines YSLoginWebJP class.
 * It includes methods to send login page layout.
 *
 * @package YggDore.Server.UserWeb.Theme.JP
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggWebRequest class
 */
require_once( "YggDore/Base/YggWebRequest.php" );
/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YggTool class
 */
require_once( "YggDore/Base/YggTool.php" );
/**
 * Require YSWPrefix class
 */
require_once( "YggDore/Server/BaseWeb/YSWPrefix.php" );
/**
 * Require YSWBaseJP class
 */
require_once( "YggDore/Server/BaseWeb/Theme/JP/YSWBaseJP.php" );


/**
 * Login page layout class
 *
 * This class has methods to send login page layout.
 *
 * <code>
 * YSLoginWebJP::send();
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.JP
 * @author YggDore Co.,Ltd.
 */
class YSUWLoginJP {
	/**
	 * Send login web page
	 *
	 * Login web page data is sent to client.
	 */
	public static function send()
	{
		$bw  = new YSWBaseJP;
		$pfx = $bw->getPrefix();
		$svs = $pfx->getConnProto();

		$cpfx  = YggHTML::specialChars( $pfx->getCurrent() );

		$bw->sendHeader();

?>
<meta name="ysg" content="<?php echo YggHTML::specialChars( YS_HTTPSURL . "/jp/mypage/?" . urlencode( "@_si" ) . "=" . urlencode( "@YSI@" ) . "&_isl=1" ); ?>" />
<link href="<?php echo $cpfx; ?>/share/top.css" rel="stylesheet" type="text/css" />
<?php

		$bw->sendBody();

?>
<div class="topmsg"> このアプリケーションはユグドアスカイゲートサーバを利用してログインを試すために用意されたテストツールです。<br />
<br />
この画面から<a href="http://www.yggdore.com/jp/app/tbff/">ユグドアスカイゲートツールバー</a>を利用し、ユーザIDとパスワードを入力して、ログインしてください。<br />
<br />
<a href="http://www.yggdore.com/jp/app/tbff/">ログイン方法についてはこちらをご覧下さい。</a><br />
<br />
アカウントをお持ちでなく、どこにYggDore Sky Gateがあるか分からない方は<a href="http://www.yggdore.com/jp/" class="footl">こちら</a>をご覧ください。 </div>
<?php

		$bw->sendFooter();
	}
}
?>
