<?php
/**
 * My page template class
 *
 * This file defines YSUWMPBaseJP class.
 * It includes methods to send my page layout data.
 *
 * @package YggDore.Server.UserWeb.Theme.JP
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YSWBaseJP class
 */
require_once( "YggDore/Server/BaseWeb/Theme/JP/YSWBaseJP.php" );
/**
 * Require YSUWLoginInfoJP class
 */
require_once( "YggDore/Server/UserWeb/Theme/JP/YSUWLoginInfoJP.php" );



/**
 * My page template class
 *
 * This class has methods to send my page layout data.
 *
 * <code>
 * $login = new YSUWLoginInfoJP;
 * $login->set();
 * $bw = new YSUMPBaseWeb;
 * $bw->sendHeader();
 * $bw->sendBody( $login );
 * $bw->sendFooter();
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.JP
 */
class YSUWMPBaseJP extends YSWBaseJP {
	/**
	 * Send header
	 *
	 * @param string $title Title
	 * @param string $keywords Keyword
	 * @param string $desc Description
	 */
	public function sendHeader( $title = "", $keywords = "", $desc = "" )
	{
		$pfx  = $this->getPrefix();
		$cpfx = YggHTML::specialChars( $pfx->getCurrent() );

		parent::sendHeader( $title, $keywords, $desc );
		
?>
<link href="<?php echo $cpfx; ?>/share/mypage/mypage.css" rel="stylesheet" type="text/css" />
<?php

	}


	/**
	 * Send body
	 *
	 * @param YSUWLoginInfoJP $login Login information
	 */
	public function sendBody( $login )
	{
		parent::sendBody();

?>
<div class="mpcon">
	<div class="lid">ようこそ<?php echo YggHTML::specialChars( $login->getID() ); ?>さん</div>
<?php

	}


	/**
	 * Send footer
	 */
	public function sendFooter()
	{

		echo '</div>';
		parent::sendFooter();
	}
}
?>
