<?php
/**
 * Class to manage page layout of echo
 *
 * This file defines YSUWMPEchoJP class.
 * It includes methods to manage page layout of echo.
 *
 * @package YggDore.Server.UserWeb.Theme.JP
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YSUEchoInfo class
 */
require_once( "YggDore/Server/User/YSUEchoInfo.php" );
/**
 * Require YSUWLoginInfoJP class
 */
require_once( "YggDore/Server/UserWeb/Theme/JP/YSUWLoginInfoJP.php" );
/**
 * Require YSUWMPBaseJP class
 */
require_once( "YggDore/Server/UserWeb/Theme/JP/YSUWMPBaseJP.php" );



/**
 * Class to manage page layout of echo
 *
 * This class has methods to manage page layout of echo.
 *
 * <code>
 * $login = new YSUWLoginInfoJP;
 * $login->set();
 * YSUWMPEchoJP::send( $login );
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.JP
 */
class YSUWMPEchoJP {
	/**
	 * Title
	 */
	const TITLE = "Echo";
	/**
	 * Echo mode
	 */
	const MODE_ECHO = "送信";


	/**
	 * Send input page
	 *
	 * @param YSUWLoginInfoJP $login Login information
	 * @param YSUEchoInfo $ei Echo information
	 */
	public static function send( $login, $ei )
	{
		$echo = $ei->getText();

		$bw = new YSUWMPBaseJP;

		$pfx  = $bw->getPrefix();
		$cpfx = YggHTML::specialChars( $pfx->getCurrent() );

		$sidq = $login->getKeepURLQuot();

		$bw->sendHeader( self::TITLE );

?>
<link href="<?php echo $cpfx; ?>/share/mypage/echo/echo.css" rel="stylesheet" type="text/css" />
<?php

		$bw->sendBody( $login );

?>
<form action="<?php echo $cpfx; ?>/jp/mypage/echo/" method="post">
<?php

		echo $login->getKeepHiddenTag()

?>
<div class="form"><input name="echo" type="text" size="40" /> <input type="submit" name="fmd" id="fmd" value="<?php echo self::MODE_ECHO; ?>" /></div>
</form>
<?php

		if( $echo !== null ){
			echo '<div class="dmk"><img src="' . $cpfx . '/share/mypage/echo/downmk.gif" width="14" height="14" /></div>' .
			     '<div class="einf">' .
			     str_replace( YGG_EOL, "<br />", YggHTML::specialChars($echo) ) .
				 '</div>';
		}

?>
<div class="back"><a href="<?php echo $cpfx; ?>/jp/mypage/<?php echo $sidq; ?>"><img src="<?php echo $cpfx; ?>/share/mypage/echo/back.gif" alt="Back" width="110" height="53" border="0" /></a></div>
<?php

		$bw->sendFooter();
	}
}
?>
