<?php
/**
 * Class to manage page layout of login ID and password change
 *
 * This file defines YSUWMPTopJP class.
 * It includes methods to manage page layout of top of my page.
 *
 * @package YggDore.Server.UserWeb.Theme.JP
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YSUWLoginInfoJP class
 */
require_once( "YggDore/Server/UserWeb/Theme/JP/YSUWLoginInfoJP.php" );
/**
 * Require YSUWMPBaseJP class
 */
require_once( "YggDore/Server/UserWeb/Theme/JP/YSUWMPBaseJP.php" );



/**
 * Class to manage page layout of login ID and password change
 *
 * This class has methods to manage page layout of top of my page.
 *
 * <code>
 * $login = new YSUWLoginInfoJP;
 * $login->set();
 * YSUWMPTopJP::send( $login );
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.JP
 */
class YSUWMPTopJP {
	/**
	 * Title
	 */
	const TITLE = "マイページ";


	/**
	 * Send input page
	 *
	 * @param YSUWLoginInfoJP $login Login information
	 */
	public static function send( $login )
	{
		$bw = new YSUWMPBaseJP;

		$pfx  = $bw->getPrefix();
		$cpfx = YggHTML::specialChars( $pfx->getCurrent() );

		$sidq = $login->getKeepURLQuot();

		$bw->sendHeader( self::TITLE );
?>
<link href="<?php echo $cpfx; ?>/share/mypage/mypagetop.css" rel="stylesheet" type="text/css" />
<?php

		$bw->sendBody( $login );

?>
<div class="mptle"><a href="<?php echo $cpfx; ?>/jp/mypage/echo/<?php echo $sidq; ?>"><img src="<?php echo $cpfx; ?>/share/mypage/echo.gif" alt="Echo" width="71" height="35" border="0" /></a></div>
<div class="mpitr">入力した内容を返すフォームテストアプリです。</div>
<div class="mptle"><a href="<?php echo $cpfx; ?>/jp/mypage/logout/<?php echo $sidq; ?>"><img src="<?php echo $cpfx; ?>/share/mypage/logout.gif" alt="Logout" width="100" height="35" border="0" /></a></div>
<div class="mpitre">ログアウトしてテストを終了します。</div>
<?php

		$bw->sendFooter();
	}
}
?>
