<?php
/**
 * Login page layout class
 *
 * This file defines YSLoginWebJPM class.
 * It includes methods to send login page layout.
 *
 * @package YggDore.Server.UserWeb.Theme.JPM
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggWebRequest class
 */
require_once( "YggDore/Base/YggWebRequest.php" );
/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YggTool class
 */
require_once( "YggDore/Base/YggTool.php" );
/**
 * Require YSThemeWebJPM class
 */
require_once( "YggDore/Server/Base/Theme/JPM/YSThemeJPM.php" );
/**
 * Require YSWPrefix class
 */
require_once( "YggDore/Server/BaseWeb/YSWPrefix.php" );
/**
 * Require YSWBaseJPM class
 */
require_once( "YggDore/Server/BaseWeb/Theme/JPM/YSWBaseJPM.php" );


/**
 * Login page layout class
 *
 * This class has methods to send login page layout.
 *
 * <code>
 * YSLoginWebJPM::send();
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.JPM
 * @author YggDore Co.,Ltd.
 */
class YSUWLoginJPM {
	/**
	 * Send login web page
	 *
	 * Login web page data is sent to client.
	 */
	public static function send()
	{
		$bw  = new YSWBaseJPM;
		$pfx = $bw->getPrefix();
		$svs = $pfx->getConnProto();

		$cpfx  = YggHTML::specialChars( $pfx->getCurrent() );

		ob_start();

		$bw->sendHeader();

?>
<meta name="ysg" content="<?php echo YggHTML::specialChars( YS_HTTPSURL . "/jpm/mypage/?" . urlencode( "@_si" ) . "=" . urlencode( "@YSI@" ) . "&_isl=1" ); ?>" />
<?php

		$bw->sendBody();

?>
<center>
	<img src="<?php echo $cpfx; ?>/jpm/logo.jpg" alt="ユグドアスカイゲートテストサーバ" /><br />
	<br />
	<img src="<?php echo $cpfx; ?>/jpm/ysg.jpg" alt="YggDore Sky Gate" /><br />
	<br />
</center>
<br />
このｱﾌﾟﾘｹｰｼｮﾝはﾕｸﾞﾄﾞｱｽｶｲｹﾞｰﾄｻｰﾊﾞを利用してﾛｸﾞｲﾝを試すために用意されたﾃｽﾄﾂｰﾙです。<br />
<br />
<br />
<?php

		$bw->sendFooter();
		YSThemeJPM::convOut();
	}
}
?>
