<?php
/**
 * My page template class
 *
 * This file defines YSUWMPBaseJPM class.
 * It includes methods to send my page layout data.
 *
 * @package YggDore.Server.UserWeb.Theme.JPM
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YSWBaseJPM class
 */
require_once( "YggDore/Server/BaseWeb/Theme/JPM/YSWBaseJPM.php" );
/**
 * Require YSUWLoginInfoJPM class
 */
require_once( "YggDore/Server/UserWeb/Theme/JPM/YSUWLoginInfoJPM.php" );



/**
 * My page template class
 *
 * This class has methods to send my page layout data.
 *
 * <code>
 * $login = new YSUWLoginInfoJPM;
 * $login->set();
 * $bw = new YSUMPBaseWeb;
 * $bw->sendHeader();
 * $bw->sendBody( $login );
 * $bw->sendFooter();
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.JPM
 */
class YSUWMPBaseJPM extends YSWBaseJPM {
	/**
	 * Send body
	 *
	 * @param YSUWLoginInfoJPM $login Login information
	 */
	public function sendBody( $login )
	{
		parent::sendBody();

		echo YggHTML::specialChars( $login->getID() ) . 'さん<br /><br />';
	}
}
?>
