<?php
/**
 * Class to manage page layout of echo
 *
 * This file defines YSUWMPEchoJPM class.
 * It includes methods to manage page layout of echo.
 *
 * @package YggDore.Server.UserWeb.Theme.JPM
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YSThemeWebJPM class
 */
require_once( "YggDore/Server/Base/Theme/JPM/YSThemeJPM.php" );
/**
 * Require YSUEchoInfo class
 */
require_once( "YggDore/Server/User/YSUEchoInfo.php" );
/**
 * Require YSUWLoginInfoJPM class
 */
require_once( "YggDore/Server/UserWeb/Theme/JPM/YSUWLoginInfoJPM.php" );
/**
 * Require YSUWMPBaseJPM class
 */
require_once( "YggDore/Server/UserWeb/Theme/JPM/YSUWMPBaseJPM.php" );



/**
 * Class to manage page layout of echo
 *
 * This class has methods to manage page layout of echo.
 *
 * <code>
 * $login = new YSUWLoginInfoJPM;
 * $login->set();
 * YSUWMPEchoJPM::send( $login );
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.JPM
 */
class YSUWMPEchoJPM {
	/**
	 * Title
	 */
	const TITLE = "Echo";
	/**
	 * Echo mode
	 */
	const MODE_ECHO = "送信";


	/**
	 * Send input page
	 *
	 * @param YSUWLoginInfoJPM $login Login information
	 * @param YSUEchoInfo $ei Echo information
	 */
	public static function send( $login, $ei )
	{
		$echo = $ei->getText();

		$bw = new YSUWMPBaseJPM;

		$pfx  = $bw->getPrefix();
		$cpfx = YggHTML::specialChars( $pfx->getCurrent() );

		$sidq = $login->getKeepURLQuot();

		ob_start();

		$bw->sendHeader( self::TITLE );
		$bw->sendBody( $login );

?>
<form action="<?php echo $cpfx; ?>/jpm/mypage/echo/" method="post">
<?php

		echo $login->getKeepHiddenTag()

?>
<input name="echo" type="text" size="10" /><br />
<input name="fmd" type="submit" value="送信" /><br />
<br />
<?php

		if( $echo !== null ){
			echo '最後の入力内容：<br />' .
			     str_replace( YGG_EOL, "<br />", YggHTML::specialChars($echo) ) .
				 '<br /><br />';
		}

?>
<a href="<?php echo $cpfx; ?>/jpm/mypage/<?php echo $sidq; ?>">戻る</a><br />
<br />
<?php

		$bw->sendFooter();
		YSThemeJPM::convOut();
	}
}
?>
