<?php
/**
 * Class to manage page layout of login ID and password change
 *
 * This file defines YSUWMPTopJPM class.
 * It includes methods to manage page layout of top of my page.
 *
 * @package YggDore.Server.UserWeb.Theme.JPM
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );
/**
 * Require YSUWLoginInfoJPM class
 */
require_once( "YggDore/Server/UserWeb/Theme/JPM/YSUWLoginInfoJPM.php" );
/**
 * Require YSUWMPBaseJPM class
 */
require_once( "YggDore/Server/UserWeb/Theme/JPM/YSUWMPBaseJPM.php" );



/**
 * Class to manage page layout of login ID and password change
 *
 * This class has methods to manage page layout of top of my page.
 *
 * <code>
 * $login = new YSUWLoginInfoJPM;
 * $login->set();
 * YSUWMPTopJPM::send( $login );
 * </code>
 *
 * @package YggDore.Server.UserWeb.Theme.JPM
 */
class YSUWMPTopJPM {
	/**
	 * Title
	 */
	const TITLE = "マイページ";


	/**
	 * Send input page
	 *
	 * @param YSUWLoginInfoJPM $login Login information
	 */
	public static function send( $login )
	{
		$bw = new YSUWMPBaseJPM;

		$pfx  = $bw->getPrefix();
		$cpfx = YggHTML::specialChars( $pfx->getCurrent() );

		$sidq = $login->getKeepURLQuot();

		ob_start();

		$bw->sendHeader( self::TITLE );
		$bw->sendBody( $login );

?>
> <a href="<?php echo $cpfx; ?>/jpm/mypage/echo/<?php echo $sidq; ?>">Echo</a><br />
入力した内容を返すﾌｫｰﾑﾃｽﾄです。<br />
<br />
> <a href="<?php echo $cpfx; ?>/jpm/mypage/logout/<?php echo $sidq; ?>">Logout</a><br />
ﾛｸﾞｱｳﾄしてﾃｽﾄを終了します。<br />
<br />
<?php

		$bw->sendFooter();
		YSThemeJPM::convOut();
	}
}
?>
