<?php
/**
 * Login class
 *
 * This file defines YSUWLoginControlBase class.
 * It includes methods to control login.
 *
 * @package YggDore.Server.UserWeb
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YggWebRequest class
 */
require_once( "YggDore/Base/YggWebRequest.php" );
/**
 * Require YSGClient class
 */
require_once( "YggDore/SkyGate/YSGClient.php" );
/**
 * Require configuration file
 */
require_once( "YggDore/Server/Config/Config.php" );
/**
 * Require YSSession class
 */
require_once( "YggDore/Server/Base/YSSession.php" );



/**
 * SQL query to create user
 */
define(
	"YSULB_QUERY_CREATEUSER",
	"CALL insertUser ( %ukey% )"
);



/**
 * Login class
 *
 * This class has methods to control login.
 *
 * <code>
 * $login = new YSUWLoginControlBase;
 * $login->start();
 * $login->stop();
 * </code>
 *
 * @package YggDore.Server.UserWeb
 */
abstract class YSUWLoginControlBase {
	/**
	 * Session
	 */
	private $_sess;
	/**
	 * MySQLi connection
	 */
	private $_mysqli;


	/**
	 * Constructor
	 *
	 * The instance is initialized.
	 */
	public function __constructor()
	{
		$this->_sess   = null;
		$this->_mysqli = null;
	}
	
	
	/**
	 * Check instance data
	 *
	 * This method checks whether member variables are valid.<br />
	 * This method returns TRUE when they are valid, otherwise returns FALSE.
	 *
	 * @return boolean
	 */
	public function isSetIns()
	{
		if( $this->_sess === null ){
			return false;
		}

		return true;
	}


	/**
	 * Get login session ID
	 *
	 * This method returns value of the instance.<br />
	 * This method throws BadMethodCallException when error occurs.
	 *
	 * @return YggSessionID
	 */
	public function getSessionID()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		return $this->_sess->getSessionID();
	}


	/**
	 * Get session data area
	 *
	 * This method returns value of the instance.<br />
	 * This method throws BadMethodCallException when error occurs.
	 *
	 * @return mixed
	 */
	public function &getSDA()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		return $this->_sess->getSDA();
	}


	/**
	 * Get mysqli connection
	 *
	 * This method returns value of the instance.<br />
	 * This method throws BadMethodCallException when error occurs.
	 *
	 * @return YggMySQLi
	 */
	public function getMySQLi()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		return $this->_mysqli;
	}


	/**
	 * Start login
	 *
	 * This method connects to database and starts session used its connection,
	 *
	 * @return string_or_null User ID<br />
	 * When a user successes to login, user ID is returned,
	 * otherwise return NULL.
	 */
	public function start()
	{
		$lang = $this->_getLang();

		$secnm = "YSTheme" . $lang;
		$elnm  = "YSUWLogin" . $lang;
		$eenm  = "YSWError" . $lang;

		$mysqli = null;
		try{
			$mysqli = YSMySQLi::connect();
		}
		catch( Exception $e ){
			call_user_func( array( $eenm, "send" ), $e );
			return null;
		}

		$id = null;
		try{
			$req = YggWebRequest::getRequestArray( array( "_si", "_isl" ) );
			if( $req['_isl'] == "1" ){
				$svr = YggWebRequest::getServerArray(
					array( YS_RAKEY, "HTTP_USER_AGENT" )
				);

				$wn = YS_WORLD;
				if( $wn == "" ){
					$wn = YggWebRequest::getServer( "SERVER_NAME" );
					if( $wn == "" ){
						throw new RuntimeException;
					}
				}

				$cert = YSGClient::certRaw(
					$req['_si'],
					array(
						"YCIP" => $svr[YS_RAKEY],
						"YCUA" => $svr['HTTP_USER_AGENT'],
						"YWN"  => $wn
					)
				);
				$id = $cert['id'];

				$this->_createUser( $id, $mysqli );
			}
		}
		catch( Exception $e ){
			$mysqli->close();
			call_user_func( array( $eenm, "send" ), $e );
			return null;
		}

		$sess = null;
		try{
			$sess = new YSSession( $mysqli );
			$sess->start();
		}
		catch( Exception $e ){
			$mysqli->close();
			call_user_func( array( $eenm, "send" ), $e );
			return null;
		}

		$sd =& $sess->getSDA();
		if( $id !== null ){
			$sd['ukey'] = $id;
		}
		elseif( !isset($sd['ukey']) ){
			$sess->stop();
			$mysqli->close();
			call_user_func( array( $elnm, "send" ) );
			return null;
		}

		$this->_sess   = $sess;
		$this->_mysqli = $mysqli;
		return $sd['ukey'];
	}

	
	/**
	 * Create a user
	 *
	 * This method initializes database of the user.
	 *
	 * @param string $ukey User key
	 * @param YggMySQLi $mysqli Database connection
	 */
	private function _createUser( $ukey, $mysqli )
	{
		$sql = $mysqli->sql(
			YSULB_QUERY_CREATEUSER,
			array( "ukey" => $ukey ),
			array( "ukey" => YggMySQLi::STRING )
		);
		$rts = $mysqli->query( $sql );
		if( !$rts ){
			throw new RuntimeException;
		}
	}

	
	/**
	 * Stop login
	 *
	 * This method must be called after YSUWLoginControlBase::start method.
	 * Session data is saved, database connection is closed,
	 * and member variables are cleared.
	 */
	public function stop()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		$this->_sess->stop();

		$this->_mysqli->close();

		$this->_sess   = null;
		$this->_mysqli = null;
	}


	/**
	 * Get language
	 *
	 * Language is returned.
	 * This method must override and set your language from extended class.
	 *
	 * @return string Language
	 */
	protected abstract function _getLang();
}
?>
