<?php
/**
 * Login information class
 *
 * This file defines YSUWLoginInfoBase class.
 * It includes methods to manage login information.
 *
 * @package YggDore.Server.UserWeb
 * @author YggDore Co.,Ltd.
 */



/**
 * Require YSUWLoginControlBase class
 */
require_once( "YggDore/Server/UserWeb/YSUWLoginControlBase.php" );



/**
 * Login information class
 *
 * This method has methods to manage login information.
 *
 * <code>
 * $login = new YSUWLoginInfoBase;
 * $lctl  = $login->set();
 * $lctl->stop();
 * </code>
 *
 * @package YggDore.Server.UserWeb
 */
abstract class YSUWLoginInfoBase {
	/**
	 * Session ID
	 */
	private $_sid;
	/**
	 * User ID
	 */
	private $_id;


	/**
	 * Constructor
	 *
	 * The instance is initialized.
	 */
	public function __constructor()
	{
		$this->_sid = null;
		$this->_id  = null;
	}
	
	
	/**
	 * Check instance data
	 *
	 * This method checks whether member variables are valid.<br />
	 * This method returns TRUE when they are valid, otherwise returns FALSE.
	 *
	 * @return boolean
	 */
	public function isSetIns()
	{
		if( $this->_sid === null ){
			return false;
		}

		return true;
	}


	/**
	 * Get login session ID
	 *
	 * This method returns value of the instance.<br />
	 * This method throws BadMethodCallException when error occurs.
	 *
	 * @return YggSessionID
	 */
	public function getSessionID()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		return $this->_sid();
	}


	/**
	 * Get user ID
	 *
	 * This method returns value of the instance.<br />
	 * This method throws BadMethodCallException when error occurs.
	 *
	 * @return string
	 */
	public function getID()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		return $this->_id;
	}


	/**
	 * Get all instance data
	 *
	 * This method returns value of the instance.<br />
	 * This method throws BadMethodCallException when error occurs.
	 *
	 * @return array<br />
	 * (It has the following elements)<br />
	 * sid : (YggSessionID) Session ID<br />
	 * id : (string) User ID
	 */
	public function get()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		return array(
			"sid" => $this->_sid,
			"id"  => $this->_id
		);
	}

	
	/**
	 * Set login information
	 *
	 * This method starts login session and set login information to the instance.
	 *
	 * @return YSUWLoginControlBase Login session
	 */
	public function set()
	{
		$lang = $this->_getLang();

		$lcnm  = "YSUWLoginControl" . $lang;
		$login = new $lcnm;
		$id   = $login->start();
		if( $id === null ){
			throw new UnexpectedValueException;
		}

		$this->_sid = $login->getSessionID();
		$this->_id  = $id;

		return $login;
	}


	/**
	 * Create session data fomatted as url encode (Starting amparsand)
	 *
	 * The url format value converted session data is returned.
	 * Its first character is amparsand.
	 * Empty string is returned if session order mode is cookie.
	 * This method is as same as PHP's SID.
	 *
	 * @return string
	 */
	public function getKeepURLAmp()
	{
		return $this->_sid->getKeepURLAmp();
	}


	/**
	 * Create session data fomatted as url encode (Starting question)
	 *
	 * The url format value converted session data is returned.
	 * Its first character is question.
	 * Empty string is returned if session order mode is cookie.
	 * This method is as same as PHP's SID.
	 *
	 * @return string
	 */
	public function getKeepURLQuot()
	{
		return $this->_sid->getKeepURLQuot();
	}


	/**
	 * Create session data fomatted as (x)html hidden tag
	 *
	 * The (x)html hidden tag converted session data is returned.
	 * Its format is [<input type="hidden" name="name" value="value">].
	 * Empty string is returned if session order mode is cookie.
	 * This method is as same as PHP's SID.
	 *
	 * @param boolean $isx XHTML mode
	 * @return string
	 */
	public function getKeepHiddenTag( $isx = true )
	{
		return $this->_sid->getKeepHiddenTag( $isx );
	}

	
	/**
	 * Get language
	 *
	 * Language is returned.
	 * This method must override and set your language from extended class.
	 *
	 * @return string Language
	 */
	protected abstract function _getLang();
}
?>
