<?php
/**
 * Class to create one time key
 *
 * This file defines YSGOTK class.
 * It includes methods to create one time key.
 *
 * @package YggDore.SkyGate
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggString class
 */
require_once( "YggDore/Base/YggString.php" );


/**
 * Class to create one time key
 *
 * This class has methods to create one time key.
 *
 * <code>
 * $otk = new YSGOTK;
 * $otk->set();
 * </code>
 *
 * @package YggDore.SkyGate
 */
class YSGOTK {
	/**
	 * One time key
	 */
	private $_otk;


	/**
	 * Constructor
	 *
	 * The instance is initialized.
	 */
	public function __construct()
	{
		$this->clear();
	}
	

	/**
	 * Clear
	 *
	 * Member variables of the instance is initialized.
	 */
	public function clear()
	{
		$this->_otk = null;
	}


	/**
	 * Check instance data
	 *
	 * This method checks whether member variables are valid.<br />
	 * This method returns TRUE when they are valid, otherwise returns FALSE.
	 *
	 * @return boolean
	 */
	public function isSetIns()
	{
		if( $this->_otk === null ){
			return false;
		}

		return true;
	}


	/**
	 * Get one time key
	 *
	 * This method returns value of the instance.<br />
	 * This method throws BadMethodCallException when error occurs.
	 *
	 * @return string
	 */
	public function get()
	{
		if( !$this->isSetIns() ){
			throw new BadMethodCallException;
		}

		return $this->_otk;
	}


	/**
     * Set data
	 *
	 * A one time key creates and set it to the instance.
	 *
	 * @param integer $klen One time key length
     */
	public function set( $klen = 64 )
	{
		if( $klen < 0 ){
			throw new UnexpectedValueException;
		}

		$this->_otk = YggString::random( $klen );
	}
}
?>
