<?php
/**
 * XML response class for YggDore Sky Gate protocol
 *
 * This file defines YSGResXML class.
 * It includes methods to send xml response.
 *
 * @package YggDore.SkyGate
 * @author YggDore Co.,Ltd.
 */


/**
 * Require YggHTML class
 */
require_once( "YggDore/Base/YggHTML.php" );


/**
 * XML response class for YggDore Sky Gate protocol
 *
 * This class has methods to send xml response.
 *
 * <code>
 * YSGResXML::sendError( YSErrorXML::ERROR );
 * </code>
 *
 * @package YggDore.SkyGate
 */
class YSGResXML {
	/**
	 * Failed certification status of error
	 */
	const ES_UNAUTH = 600;
	/**
	 * Response status of error
	 */
	const ES_ERROR  = 500;
	/**
	 * Response status of server busy
	 */
	const ES_BUSY   = 501;


	/**
	 * Send error responce XML to client
	 *
	 * @param integer $code Response status code
	 */
	public static function sendError( $code = self::ES_ERROR )
	{
		header( "Content-Type: text/xml" );

?>
<?xml version="1.0" encoding="UTF-8"?>
<Error>
	<Version>1.0</Version>
	<Code><?php echo YggHTML::specialChars($code); ?></Code>
</Error>
<?php

	}


	/**
	 * Send XML of ID information to client
	 *
	 * @param string $key Key
	 * @param string $world World name
	 */
	public static function sendID( $key, $world )
	{
		header( "Content-Type: text/xml" );

?>
<?xml version="1.0" encoding="UTF-8"?>
<ID>
	<Version>1.0</Version>
	<Key><?php echo YggHTML::specialChars($key); ?></Key>
	<World><?php echo YggHTML::specialChars($world); ?></World>
</ID>
<?php

	}


	/**
	 * Send XML of login interface
	 *
	 * @param array $lid Login interface data<br />
	 * (It has the following elements)<br />
	 * surl : (string) YSG server URL<br />
	 * sun : (string) Service URL request name<br />
	 * iidn : (string) Interface ID request name<br />
	 * iid : (string) Interface ID<br />
	 * idn : (string) Login ID request name<br />
	 * psn : (string) Password request name<br />
	 * chal : (string) Challenge<br />
	 * que : (array) Addition query information<br />
	 * (Its each records has the following elements)<br />
	 * => key : (string) Query key name<br />
	 * => value : (string) Query value
	 */
	public static function sendLItr( $lid )
	{
		header( "Content-Type: text/xml" );

?>
<?xml version="1.0" encoding="UTF-8"?>
<Interface>
	<Version>1.0</Version>
	<Server><?php echo YggHTML::specialChars($lid['surl']); ?></Server>
	<Service key="<?php echo YggHTML::specialChars($lid['sun']); ?>" />
	<IID key="<?php echo YggHTML::specialChars($lid['iidn']); ?>"><?php echo YggHTML::specialChars($lid['iid']); ?></IID>
	<ID key="<?php echo YggHTML::specialChars($lid['idn']); ?>" />
	<Password key="<?php echo YggHTML::specialChars($lid['psn']); ?>" challenge="<?php echo YggHTML::specialChars($lid['chal']); ?>" />
<?php

		if( count($lid['que']) > 0 ){
			echo "\t<Query>" . YGG_EOL;

			foreach( $lid['que'] as $quer ){
				echo "\t\t" .
					'<Record key="' . YggHTML::specialChars($quer['key']) . '">' .
					YggHTML::specialChars($quer['value']) .
					"</Record>" . YGG_EOL;
			}

			echo "\t</Query>" . YGG_EOL;
		}

?>
</Interface>
<?php

	}
}
?>
