-- Stored procedure definition 



delimiter //



--
-- Part of dropping procedure
-- 
DROP PROCEDURE IF EXISTS insertUser; //
DROP PROCEDURE IF EXISTS cleanUser; //
DROP PROCEDURE IF EXISTS echoText; //



--
-- Part of user registration
--

-- Register a request of user registration to temporary table
-- (Argument)
-- uk : User key
CREATE PROCEDURE insertUser (
	IN uk VARCHAR(255)
)
BEGIN
	DECLARE rc INTEGER;

	INSERT IGNORE INTO USER VALUES ( uk, NOW(), NULL );
	INSERT IGNORE INTO ECHO VALUES ( uk, NULL, NULL );
END
//


-- Clean table to store request of user registration
-- (Argument)
-- des : Records deletion second from last access time
CREATE PROCEDURE cleanUser (
	IN des INTEGER
)
BEGIN
	DELETE
		USER, ECHO
	FROM 
		USER, ECHO
	WHERE
		USER.LAT <= NOW() - INTERVAL des SECOND AND
		USER.UKEY = ECHO.UKEY;
END
//


-- Echo message registration
-- (Argument)
-- uk : User key
-- et : Echo data
CREATE PROCEDURE echoText (
	IN uk VARCHAR(255),
	IN et TEXT
)
BEGIN
	UPDATE ECHO SET ETXT = et WHERE UKEY = uk;
END
//


delimiter ;
