-- Table Definition

-- Set string encoding
SET NAMES UTF8;



-- User information table
CREATE TABLE USER (
	UKEY		VARCHAR(255) BINARY NOT NULL,	-- User key
	REGT		DATETIME NOT NULL,				-- Registration time
	LAT			DATETIME,						-- Last access time
	PRIMARY KEY ( UKEY ),
	KEY INDEX_REGT ( REGT ),
	KEY INDEX_LAT ( LAT )
);


-- Echo table
CREATE TABLE ECHO (
	UKEY		VARCHAR(255) BINARY NOT NULL,	-- User key
	ETXT		TEXT,							-- Echo data
	REGT		DATETIME,						-- Registration time
	PRIMARY KEY ( UKEY ),
	KEY INDEX_REGT ( REGT )
);


-- User login session table
CREATE TABLE SESSION (
	SKEY  VARCHAR(32) BINARY NOT NULL,			-- Session key
	DATA  TEXT,									-- Data
	CTIME DATETIME NOT NULL,					-- Creation time
	ATIME DATETIME NOT NULL,					-- Last access time
	ISACT BOOLEAN NOT NULL,						-- Active flag
	PRIMARY KEY ( SKEY ),
	KEY INDEX_CTIME ( CTIME ),
	KEY INDEX_ATIME ( ATIME ),
	KEY INDEX_ISACT ( ISACT )
);
